/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ResourceUtils.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ResourceUtils.class);

    private ResourceUtils() {
    }

    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, boolean root, boolean enableStatic) {
        ClassResourceInfo cri = new ClassResourceInfo(rClass, sClass, root, enableStatic);
        if (root) {
            URITemplate t = URITemplate.createTemplate(cri, cri.getPath());
            cri.setURITemplate(t);
        }
        ResourceUtils.evaluateResourceClass(cri, enableStatic);
        return ResourceUtils.checkMethodDispatcher(cri) ? cri : null;
    }

    private static void evaluateResourceClass(ClassResourceInfo cri, boolean enableStatic) {
        MethodDispatcher md = new MethodDispatcher();
        for (Method m : cri.getServiceClass().getMethods()) {
            Method annotatedMethod = AnnotationUtils.getAnnotatedMethod(m);
            String httpMethod = AnnotationUtils.getHttpMethodValue(annotatedMethod);
            Path path = AnnotationUtils.getMethodAnnotation(annotatedMethod, Path.class);
            if (httpMethod == null && path == null) continue;
            md.bind(ResourceUtils.createOperationInfo(m, annotatedMethod, cri, path, httpMethod), m);
            if (httpMethod != null) continue;
            Class<?> subClass = m.getReturnType();
            if (!enableStatic) continue;
            ClassResourceInfo subCri = cri.findResource(subClass, subClass);
            if (subCri == null) {
                ClassResourceInfo classResourceInfo = subCri = subClass == cri.getServiceClass() ? cri : ResourceUtils.createClassResourceInfo(subClass, subClass, false, enableStatic);
            }
            if (subCri == null) continue;
            cri.addSubClassResourceInfo(subCri);
        }
        cri.setMethodDispatcher(md);
    }

    public static Constructor findResourceConstructor(Class<?> resourceClass, boolean perRequest) {
        LinkedList cs = new LinkedList();
        for (Constructor<?> c : resourceClass.getConstructors()) {
            Class<?>[] params = c.getParameterTypes();
            Annotation[][] anns = c.getParameterAnnotations();
            boolean match = true;
            for (int i = 0; i < params.length; ++i) {
                if (!perRequest) {
                    if (AnnotationUtils.getAnnotation(anns[i], Context.class) != null && AnnotationUtils.isContextClass(params[i])) continue;
                    match = false;
                    break;
                }
                if (AnnotationUtils.isValidParamAnnotations(anns[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            cs.add(c);
        }
        Collections.sort(cs, new Comparator<Constructor>(){

            @Override
            public int compare(Constructor c1, Constructor c2) {
                int p2;
                int p1 = c1.getParameterTypes().length;
                return p1 > (p2 = c2.getParameterTypes().length) ? -1 : (p1 < p2 ? 1 : 0);
            }
        });
        return cs.size() == 0 ? null : (Constructor)cs.get(0);
    }

    private static OperationResourceInfo createOperationInfo(Method m, Method annotatedMethod, ClassResourceInfo cri, Path path, String httpMethod) {
        OperationResourceInfo ori = new OperationResourceInfo(m, cri);
        URITemplate t = URITemplate.createTemplate(cri, path);
        ori.setURITemplate(t);
        ori.setHttpMethod(httpMethod);
        ori.setAnnotatedMethod(annotatedMethod);
        return ori;
    }

    private static boolean checkMethodDispatcher(ClassResourceInfo cr) {
        if (cr.getMethodDispatcher().getOperationResourceInfos().isEmpty()) {
            LOG.warning(new Message("NO_RESOURCE_OP_EXC", BUNDLE, cr.getServiceClass().getName()).toString());
            return false;
        }
        return true;
    }
}

