/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class SourceProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Source> {
    public boolean isWriteable(Class<?> type) {
        return Source.class.isAssignableFrom(type);
    }

    public boolean isReadable(Class<?> type) {
        return Source.class.isAssignableFrom(type);
    }

    public Object readFrom(Class<Object> source, MediaType media, MultivaluedMap<String, String> httpHeaders, InputStream is) throws IOException {
        if (DOMSource.class.isAssignableFrom(source)) {
            Document doc = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(is);
            }
            catch (Exception e) {
                IOException ioex = new IOException("Problem creating a Source object");
                ioex.setStackTrace(e.getStackTrace());
                throw ioex;
            }
            return new DOMSource(doc);
        }
        if (StreamSource.class.isAssignableFrom(source) || Source.class.isAssignableFrom(source)) {
            return new StreamSource(is);
        }
        throw new IOException("Unrecognized source");
    }

    public void writeTo(Source source, MediaType media, MultivaluedMap<String, Object> httpHeaders, OutputStream os) throws IOException {
        StreamResult result = new StreamResult(os);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Transformer t = tf.newTransformer();
            t.transform(source, result);
        }
        catch (TransformerException te) {
            te.printStackTrace();
        }
    }

    public long getSize(Source source) {
        return -1L;
    }
}

