/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.WeakHashMap;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public final class JAXBElementProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    static Map<Class, JAXBContext> jaxbContexts = new WeakHashMap<Class, JAXBContext>();

    public boolean isWriteable(Class<?> type) {
        return type.getAnnotation(XmlRootElement.class) != null;
    }

    public boolean isReadable(Class<?> type) {
        return type.getAnnotation(XmlRootElement.class) != null;
    }

    public long getSize(Object o) {
        return -1L;
    }

    public Object readFrom(Class<Object> type, MediaType m, MultivaluedMap<String, String> headers, InputStream is) {
        try {
            JAXBContext context = this.getJAXBContext(type);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return unmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeTo(Object obj, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) {
        try {
            JAXBContext context = this.getJAXBContext(obj.getClass());
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal(obj, os);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getJAXBContext(Class type) throws JAXBException {
        Map<Class, JAXBContext> map = jaxbContexts;
        synchronized (map) {
            JAXBContext context = jaxbContexts.get(type);
            if (context == null) {
                context = JAXBContext.newInstance((Class[])new Class[]{type});
                jaxbContexts.put(type, context);
            }
            return context;
        }
    }
}

