/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.provider.HttpHeadersImpl;
import org.apache.cxf.jaxrs.provider.PathSegmentImpl;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.provider.RequestImpl;
import org.apache.cxf.jaxrs.provider.SecurityContextImpl;
import org.apache.cxf.jaxrs.provider.UriInfoImpl;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXRSUtils {
    public static final MediaType ALL_TYPES = new MediaType();
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSUtils.class);

    private JAXRSUtils() {
    }

    public static String getHttpMethodValue(Method m) {
        for (Annotation a : m.getAnnotations()) {
            HttpMethod httpM = a.annotationType().getAnnotation(HttpMethod.class);
            if (httpM == null) continue;
            return httpM.value();
        }
        for (Class<?> i : m.getDeclaringClass().getInterfaces()) {
            try {
                Method interfaceMethod = i.getMethod(m.getName(), m.getParameterTypes());
                if (interfaceMethod == null) continue;
                return JAXRSUtils.getHttpMethodValue(interfaceMethod);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        Class<?> superC = m.getDeclaringClass().getSuperclass();
        if (superC != null) {
            try {
                Method cMethod = superC.getMethod(m.getName(), m.getParameterTypes());
                if (cMethod != null) {
                    return JAXRSUtils.getHttpMethodValue(cMethod);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Annotation getMethodAnnotation(Method m, Class<? extends Annotation> aClass) {
        Annotation a = m.getAnnotation(aClass);
        if (a != null) {
            return a;
        }
        for (Class<?> i : m.getDeclaringClass().getInterfaces()) {
            a = JAXRSUtils.getClassMethodAnnotation(m, i, aClass);
            if (a == null) continue;
            return a;
        }
        Class<?> superC = m.getDeclaringClass().getSuperclass();
        if (superC != null) {
            return JAXRSUtils.getClassMethodAnnotation(m, superC, aClass);
        }
        return null;
    }

    private static Annotation getClassMethodAnnotation(Method m, Class<?> c, Class<? extends Annotation> aClass) {
        try {
            Method interfaceMethod = c.getMethod(m.getName(), m.getParameterTypes());
            if (interfaceMethod != null) {
                return JAXRSUtils.getMethodAnnotation(interfaceMethod, aClass);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static Annotation getClassAnnotation(Class<?> c, Class<? extends Annotation> aClass) {
        if (c == null) {
            return null;
        }
        Annotation p = c.getAnnotation(aClass);
        if (p != null) {
            return p;
        }
        return JAXRSUtils.getClassAnnotation(c.getSuperclass(), aClass);
    }

    public static List<PathSegment> getPathSegments(String thePath, boolean decode) {
        String[] segments = thePath.split("/");
        ArrayList<PathSegment> theList = new ArrayList<PathSegment>();
        for (String path : segments) {
            if (StringUtils.isEmpty(path)) continue;
            theList.add(new PathSegmentImpl(path, decode));
        }
        return theList;
    }

    public static List<MediaType> getMediaTypes(String[] values) {
        ArrayList<MediaType> supportedMimeTypes = new ArrayList<MediaType>(values.length);
        for (int i = 0; i < values.length; ++i) {
            supportedMimeTypes.add(MediaType.parse((String)values[i]));
        }
        return supportedMimeTypes;
    }

    public static ClassResourceInfo findSubResourceClass(ClassResourceInfo resource, Class subResourceClassType) {
        for (ClassResourceInfo subCri : resource.getSubClassResourceInfo()) {
            if (subCri.getResourceClass() != subResourceClassType) continue;
            return subCri;
        }
        return null;
    }

    public static OperationResourceInfo findTargetResourceClass(List<ClassResourceInfo> resources, String path, String httpMethod, MultivaluedMap<String, String> values, String requestContentType, String acceptContentTypes) {
        for (ClassResourceInfo resource : resources) {
            String subResourcePath;
            OperationResourceInfo ori;
            MetadataMap<String, String> map;
            URITemplate uriTemplate = resource.getURITemplate();
            if (!uriTemplate.match(path, map = new MetadataMap<String, String>()) || (ori = JAXRSUtils.findTargetMethod(resource, subResourcePath = (String)map.getFirst("FINAL_MATCH_GROUP"), httpMethod, map, requestContentType, acceptContentTypes)) == null) continue;
            values.putAll(map);
            return ori;
        }
        return null;
    }

    public static OperationResourceInfo findTargetMethod(ClassResourceInfo resource, String path, String httpMethod, MultivaluedMap<String, String> values, String requestContentType, String acceptContentTypes) {
        TreeMap<OperationResourceInfo, MultivaluedMap<String, String>> candidateList = new TreeMap<OperationResourceInfo, MultivaluedMap<String, String>>(new OperationResourceInfoComparator());
        MediaType requestType = requestContentType == null ? ALL_TYPES : MediaType.parse((String)requestContentType);
        List<MediaType> acceptTypes = JAXRSUtils.sortMediaTypes(acceptContentTypes);
        for (MediaType acceptType : acceptTypes) {
            for (OperationResourceInfo ori : resource.getMethodDispatcher().getOperationResourceInfos()) {
                String finalGroup;
                URITemplate uriTemplate = ori.getURITemplate();
                MultivaluedMap<String, String> map = JAXRSUtils.cloneMap(values);
                if (uriTemplate == null || !uriTemplate.match(path, map)) continue;
                if (ori.isSubResourceLocator() && JAXRSUtils.matchMimeTypes(requestType, acceptType, ori)) {
                    candidateList.put(ori, map);
                    continue;
                }
                if (!ori.getHttpMethod().equalsIgnoreCase(httpMethod) || !JAXRSUtils.matchMimeTypes(requestType, acceptType, ori) || (finalGroup = (String)map.getFirst((Object)"FINAL_MATCH_GROUP")) != null && !StringUtils.isEmpty(finalGroup) && !finalGroup.equals("/")) continue;
                candidateList.put(ori, map);
            }
            if (candidateList.isEmpty()) continue;
            Map.Entry firstEntry = candidateList.entrySet().iterator().next();
            values.clear();
            values.putAll((Map)firstEntry.getValue());
            return (OperationResourceInfo)firstEntry.getKey();
        }
        return null;
    }

    public static List<MediaType> getConsumeTypes(ConsumeMime cm) {
        return cm == null ? Collections.singletonList(ALL_TYPES) : JAXRSUtils.getMediaTypes(cm.value());
    }

    public static List<MediaType> getProduceTypes(ProduceMime pm) {
        return pm == null ? Collections.singletonList(ALL_TYPES) : JAXRSUtils.getMediaTypes(pm.value());
    }

    public static int compareMediaTypes(MediaType mt1, MediaType mt2) {
        if (mt1.equals((Object)mt2)) {
            float q2;
            float q1 = JAXRSUtils.getMediaTypeQualityFactor(mt1);
            int result = Float.compare(q1, q2 = JAXRSUtils.getMediaTypeQualityFactor(mt2));
            return result == 0 ? result : ~result;
        }
        if (mt1.isWildcardType() && !mt2.isWildcardType()) {
            return 1;
        }
        if (!mt1.isWildcardType() && mt2.isWildcardType()) {
            return -1;
        }
        if (mt1.getType().equals(mt2.getType())) {
            if (mt1.isWildcardSubtype() && !mt2.isWildcardSubtype()) {
                return 1;
            }
            if (!mt1.isWildcardSubtype() && mt2.isWildcardSubtype()) {
                return -1;
            }
        }
        return mt1.toString().compareTo(mt2.toString());
    }

    private static float getMediaTypeQualityFactor(MediaType mt) {
        String q = (String)mt.getParameters().get("q");
        if (q == null) {
            return 1.0f;
        }
        if (q.charAt(0) == '.') {
            q = '0' + q;
        }
        try {
            return Float.parseFloat(q);
        }
        catch (NumberFormatException numberFormatException) {
            return 1.0f;
        }
    }

    public static List<Object> processParameters(OperationResourceInfo ori, MultivaluedMap<String, String> values, Message message) {
        Method method = ori.getMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<Object> params = new ArrayList<Object>(parameterTypes.length);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object param = JAXRSUtils.processParameter(parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i], values, message, ori);
            params.add(param);
        }
        return params;
    }

    private static Object processParameter(Class<?> parameterClass, Type parameterType, Annotation[] parameterAnnotations, MultivaluedMap<String, String> values, Message message, OperationResourceInfo ori) {
        InputStream is = message.getContent(InputStream.class);
        String path = (String)message.get("relative.path");
        if ((parameterAnnotations == null || parameterAnnotations.length == 0) && ("PUT".equals(ori.getHttpMethod()) || "POST".equals(ori.getHttpMethod()))) {
            String contentType = (String)message.get("Content-Type");
            if (contentType == null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_CONTENT_TYPE_SPECIFIED", LOG, ori.getHttpMethod()));
            }
            return JAXRSUtils.readFromMessageBody(parameterClass, is, MediaType.parse((String)contentType), ori.getConsumeTypes());
        }
        if (parameterAnnotations[0].annotationType() == Context.class && ori.getClassResourceInfo().isRoot()) {
            return JAXRSUtils.createHttpContextValue(message, parameterClass);
        }
        if (parameterAnnotations[0].annotationType() == PathParam.class) {
            return JAXRSUtils.readFromUriParam((PathParam)parameterAnnotations[0], parameterClass, parameterType, parameterAnnotations, path, values);
        }
        Object result = null;
        if (parameterAnnotations[0].annotationType() == QueryParam.class) {
            result = JAXRSUtils.readQueryString((QueryParam)parameterAnnotations[0], parameterClass, message, null);
        } else if (parameterAnnotations[0].annotationType() == MatrixParam.class) {
            result = JAXRSUtils.processMatrixParam(message, ((MatrixParam)parameterAnnotations[0]).value(), parameterClass, null);
        } else if (parameterAnnotations[0].annotationType() == HeaderParam.class) {
            result = JAXRSUtils.processHeaderParam(message, ((HeaderParam)parameterAnnotations[0]).value(), parameterClass, null);
        }
        return result;
    }

    private static Object processMatrixParam(Message m, String key, Class<?> pClass, String defaultValue) {
        MultivaluedMap params;
        List values;
        List<PathSegment> segments = JAXRSUtils.getPathSegments((String)m.get(Message.PATH_INFO), true);
        String value = null;
        if (segments.size() > 0 && (values = (List)(params = segments.get(segments.size() - 1).getMatrixParameters()).get((Object)key)) != null && values.size() > 0) {
            value = (String)values.get(0);
        }
        return value == null ? defaultValue : JAXRSUtils.handleParameter(value, pClass);
    }

    public static MultivaluedMap<String, String> getMatrixParams(String path, boolean decode) {
        int index = path.indexOf(59);
        return index == -1 ? new MetadataMap<String, String>() : JAXRSUtils.getStructuredParams(path.substring(index + 1), ";", decode);
    }

    private static Object processHeaderParam(Message m, String header, Class<?> pClass, String defaultValue) {
        Map headers = (Map)m.get(Message.PROTOCOL_HEADERS);
        List values = (List)headers.get(header);
        StringBuilder sb = new StringBuilder();
        if (values != null) {
            Iterator it = values.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(',');
            }
        }
        return sb.length() > 0 ? JAXRSUtils.handleParameter(sb.toString(), pClass) : defaultValue;
    }

    public static Object createHttpContextValue(Message m, Class<?> clazz) {
        if (UriInfo.class.isAssignableFrom(clazz)) {
            MultivaluedMap templateParams = (MultivaluedMap)m.get("jaxrs.template.parameters");
            return new UriInfoImpl(m, (MultivaluedMap<String, String>)templateParams);
        }
        if (HttpHeaders.class.isAssignableFrom(clazz)) {
            return new HttpHeadersImpl(m);
        }
        if (Request.class.isAssignableFrom(clazz)) {
            return new RequestImpl(m);
        }
        if (SecurityContext.class.isAssignableFrom(clazz)) {
            return new SecurityContextImpl(m);
        }
        return null;
    }

    public static Object createServletResourceValue(Message m, Class<?> clazz) {
        if (HttpServletRequest.class.isAssignableFrom(clazz)) {
            return (HttpServletRequest)m.get("HTTP.REQUEST");
        }
        if (HttpServletResponse.class.isAssignableFrom(clazz)) {
            return (HttpServletResponse)m.get("HTTP.RESPONSE");
        }
        if (ServletContext.class.isAssignableFrom(clazz)) {
            return (ServletContext)m.get("HTTP.CONTEXT");
        }
        return null;
    }

    private static Object readFromUriParam(PathParam uriParamAnnotation, Class<?> parameter, Type parameterType, Annotation[] parameterAnnotations, String path, MultivaluedMap<String, String> values) {
        String parameterName = uriParamAnnotation.value();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        String result = null;
        List results = (List)values.get((Object)parameterName);
        if (values != null && values.size() > 0) {
            result = (String)results.get(results.size() - 1);
        }
        if (result != null) {
            return JAXRSUtils.handleParameter(result, parameter);
        }
        return result;
    }

    private static Object handleParameter(String value, Class<?> pClass) {
        if (pClass.isPrimitive()) {
            return PrimitiveUtils.read(value, pClass);
        }
        try {
            Constructor<?> c = pClass.getConstructor(String.class);
            if (c != null) {
                return c.newInstance(value);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            Method m = pClass.getMethod("valueOf", String.class);
            if (m != null && Modifier.isStatic(m.getModifiers())) {
                return m.invoke(null, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Object readQueryString(QueryParam queryParam, Class<?> parameter, Message m, String defaultValue) {
        String queryName = queryParam.value();
        String result = (String)JAXRSUtils.getStructuredParams((String)m.get(Message.QUERY_STRING), "&", true).getFirst((Object)queryName);
        if (result != null) {
            return JAXRSUtils.handleParameter(result, parameter);
        }
        return result;
    }

    public static MultivaluedMap<String, String> getStructuredParams(String query, String sep, boolean decode) {
        MetadataMap<String, String> queries = new MetadataMap<String, String>(new LinkedHashMap());
        if (!StringUtils.isEmpty(query)) {
            List<String> parts = Arrays.asList(query.split(sep));
            for (String part : parts) {
                String[] values = part.split("=");
                queries.add(values[0], values.length == 1 ? "" : (decode ? JAXRSUtils.uriDecode(values[1]) : values[1]));
            }
        }
        return queries;
    }

    public static String uriDecode(String query) {
        try {
            query = URLDecoder.decode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return query;
    }

    private static <T> Object readFromMessageBody(Class<T> targetTypeClass, InputStream is, MediaType contentType, List<MediaType> consumeTypes) {
        List<MediaType> types = JAXRSUtils.intersectMimeTypes(consumeTypes, contentType);
        MessageBodyReader<T> provider = null;
        Iterator<MediaType> i$ = types.iterator();
        if (i$.hasNext()) {
            MediaType type = i$.next();
            provider = ProviderFactory.getInstance().createMessageBodyReader(targetTypeClass, type);
            if (provider != null) {
                try {
                    return provider.readFrom(targetTypeClass, contentType, null, is);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Error deserializing input stream into target class " + targetTypeClass.getSimpleName() + ", content type : " + contentType);
                }
            }
            throw new RuntimeException("No message body reader found for target class " + targetTypeClass.getSimpleName() + ", content type : " + contentType);
        }
        return null;
    }

    public static boolean matchMimeTypes(MediaType requestContentType, MediaType acceptContentType, OperationResourceInfo ori) {
        return JAXRSUtils.intersectMimeTypes(ori.getConsumeTypes(), requestContentType).size() != 0 && JAXRSUtils.intersectMimeTypes(ori.getProduceTypes(), acceptContentType).size() != 0;
    }

    public static List<MediaType> parseMediaTypes(String types) {
        ArrayList<MediaType> acceptValues = new ArrayList<MediaType>();
        if (types != null) {
            while (types.length() > 0) {
                String tp = types;
                int index = types.indexOf(44);
                if (index != -1) {
                    tp = types.substring(0, index);
                    types = types.substring(index + 1).trim();
                } else {
                    types = "";
                }
                acceptValues.add(MediaType.parse((String)tp));
            }
        } else {
            acceptValues.add(ALL_TYPES);
        }
        return acceptValues;
    }

    public static List<MediaType> intersectMimeTypes(List<MediaType> mimeTypesA, List<MediaType> mimeTypesB) {
        LinkedHashSet<MediaType> supportedMimeTypeList = new LinkedHashSet<MediaType>();
        for (MediaType mimeTypeA : mimeTypesA) {
            for (MediaType mimeTypeB : mimeTypesB) {
                if (!mimeTypeB.isCompatible(mimeTypeA) && !mimeTypeA.isCompatible(mimeTypeB)) continue;
                String type = mimeTypeA.getType().equals("*") ? mimeTypeB.getType() : mimeTypeA.getType();
                String subtype = mimeTypeA.getSubtype().equals("*") ? mimeTypeB.getSubtype() : mimeTypeA.getSubtype();
                supportedMimeTypeList.add(new MediaType(type, subtype));
            }
        }
        return new ArrayList<MediaType>(supportedMimeTypeList);
    }

    public static List<MediaType> intersectMimeTypes(List<MediaType> mimeTypesA, MediaType mimeTypeB) {
        return JAXRSUtils.intersectMimeTypes(mimeTypesA, Collections.singletonList(mimeTypeB));
    }

    public static List<MediaType> intersectMimeTypes(String mimeTypesA, String mimeTypesB) {
        return JAXRSUtils.intersectMimeTypes(JAXRSUtils.parseMediaTypes(mimeTypesA), JAXRSUtils.parseMediaTypes(mimeTypesB));
    }

    public static List<MediaType> sortMediaTypes(String mediaTypes) {
        List<MediaType> types = JAXRSUtils.parseMediaTypes(mediaTypes);
        if (types.size() > 1) {
            Collections.sort(types, new Comparator<MediaType>(){

                @Override
                public int compare(MediaType mt1, MediaType mt2) {
                    return JAXRSUtils.compareMediaTypes(mt1, mt2);
                }
            });
        }
        return types;
    }

    public static void injectHttpContextValues(Object o, OperationResourceInfo ori, Message m) {
        for (Field f : ori.getClassResourceInfo().getHttpContexts()) {
            Object value = JAXRSUtils.createHttpContextValue(m, f.getType());
            f.setAccessible(true);
            try {
                f.set(o, value);
            }
            catch (IllegalAccessException ex) {}
        }
    }

    public static void injectServletResourceValues(Object o, OperationResourceInfo ori, Message m) {
        for (Field f : ori.getClassResourceInfo().getResources()) {
            Object value = JAXRSUtils.createServletResourceValue(m, f.getType());
            f.setAccessible(true);
            try {
                f.set(o, value);
            }
            catch (IllegalAccessException ex) {}
        }
    }

    private static <K, V> MultivaluedMap<K, V> cloneMap(MultivaluedMap<K, V> map1) {
        MetadataMap map2 = new MetadataMap();
        for (Map.Entry entry : map1.entrySet()) {
            map2.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return map2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OperationResourceInfoComparator
    implements Comparator<OperationResourceInfo> {
        private OperationResourceInfoComparator() {
        }

        @Override
        public int compare(OperationResourceInfo e1, OperationResourceInfo e2) {
            List<MediaType> mimeType1 = JAXRSUtils.getConsumeTypes(e1.getMethod().getAnnotation(ConsumeMime.class));
            List<MediaType> mimeType2 = JAXRSUtils.getConsumeTypes(e2.getMethod().getAnnotation(ConsumeMime.class));
            int result = JAXRSUtils.compareMediaTypes(mimeType1.get(0), mimeType2.get(0));
            if (result == 0) {
                List<MediaType> mimeTypeP1 = JAXRSUtils.getProduceTypes(e1.getMethod().getAnnotation(ProduceMime.class));
                List<MediaType> mimeTypeP2 = JAXRSUtils.getProduceTypes(e2.getMethod().getAnnotation(ProduceMime.class));
                return JAXRSUtils.compareMediaTypes(mimeTypeP1.get(0), mimeTypeP2.get(0));
            }
            return result;
        }
    }
}

