/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.cxf.common.util.StreamPrinter;
import org.apache.cxf.helpers.FileUtils;

public class Compiler {
    public boolean compileFiles(String[] files, File outputDir) {
        String javaClasspath;
        boolean classpathSetted;
        ArrayList<String> list = new ArrayList<String>();
        list.add("javac");
        if (outputDir != null) {
            list.add("-d");
            list.add(outputDir.getAbsolutePath().replace(File.pathSeparatorChar, '/'));
        }
        boolean bl = classpathSetted = (javaClasspath = System.getProperty("java.class.path")) != null;
        if (!classpathSetted) {
            list.add("-extdirs");
            list.add(this.getClass().getClassLoader().getResource(".").getFile() + "../lib/");
        } else {
            list.add("-classpath");
            list.add(javaClasspath);
        }
        int idx = list.size();
        list.addAll(Arrays.asList(files));
        return this.internalCompile(list.toArray(new String[list.size()]), idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean internalCompile(String[] args, int sourceFileIndex) {
        File tmpFile;
        block17: {
            boolean infoStreamPrinter2;
            Process p = null;
            String[] cmdArray = null;
            tmpFile = null;
            try {
                try {
                    if (this.isLongCommandLines(args) && sourceFileIndex >= 0) {
                        PrintWriter out = null;
                        tmpFile = FileUtils.createTempFile("cxf-compiler", null);
                        out = new PrintWriter(new FileWriter(tmpFile));
                        for (int i = sourceFileIndex; i < args.length; ++i) {
                            if (args[i].indexOf(" ") > -1) {
                                args[i] = args[i].replace(File.separatorChar, '/');
                                if (args[i].indexOf("package-info.java") > -1 && System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                                    out.println("\"" + args[i].replaceAll("/", "\\\\\\\\") + "\"");
                                    continue;
                                }
                                out.println("\"" + args[i] + "\"");
                                continue;
                            }
                            out.println(args[i]);
                        }
                        out.flush();
                        out.close();
                        cmdArray = new String[sourceFileIndex + 1];
                        System.arraycopy(args, 0, cmdArray, 0, sourceFileIndex);
                        cmdArray[sourceFileIndex] = "@" + tmpFile;
                    } else {
                        cmdArray = new String[args.length];
                        System.arraycopy(args, 0, cmdArray, 0, args.length);
                    }
                    if (System.getProperty("os.name").toLowerCase().indexOf("windows") > -1) {
                        for (int i = 0; i < cmdArray.length; ++i) {
                            if (cmdArray[i].indexOf("package-info") != -1) continue;
                            cmdArray[i] = cmdArray[i].replace('\\', '/');
                        }
                    }
                    if ((p = Runtime.getRuntime().exec(cmdArray)).getErrorStream() != null) {
                        StreamPrinter errorStreamPrinter = new StreamPrinter(p.getErrorStream(), "", System.out);
                        errorStreamPrinter.run();
                    }
                    if (p.getInputStream() != null) {
                        StreamPrinter infoStreamPrinter2 = new StreamPrinter(p.getInputStream(), "[INFO]", System.out);
                        infoStreamPrinter2.run();
                    }
                    if (p == null) break block17;
                    infoStreamPrinter2 = p.waitFor() == 0;
                    Object var9_15 = null;
                    if (tmpFile == null) return infoStreamPrinter2;
                }
                catch (SecurityException e) {
                    System.err.println("[ERROR] SecurityException during exec() of compiler \"" + args[0] + "\".");
                    Object var9_17 = null;
                    if (tmpFile == null) return false;
                    if (!tmpFile.exists()) return false;
                    FileUtils.delete(tmpFile);
                    return false;
                }
                catch (InterruptedException e) {
                    Object var9_18 = null;
                    if (tmpFile == null) return false;
                    if (!tmpFile.exists()) return false;
                    FileUtils.delete(tmpFile);
                    return false;
                }
                catch (IOException e) {
                    System.err.print("[ERROR] IOException during exec() of compiler \"" + args[0] + "\"");
                    System.err.println(". Check your path environment variable.");
                    Object var9_19 = null;
                    if (tmpFile == null) return false;
                    if (!tmpFile.exists()) return false;
                    FileUtils.delete(tmpFile);
                    return false;
                }
                if (!tmpFile.exists()) return infoStreamPrinter2;
            }
            catch (Throwable throwable) {
                Object var9_20 = null;
                if (tmpFile == null) throw throwable;
                if (!tmpFile.exists()) throw throwable;
                FileUtils.delete(tmpFile);
                throw throwable;
            }
            FileUtils.delete(tmpFile);
            return infoStreamPrinter2;
        }
        Object var9_16 = null;
        if (tmpFile == null) return false;
        if (!tmpFile.exists()) return false;
        FileUtils.delete(tmpFile);
        return false;
    }

    private boolean isLongCommandLines(String[] args) {
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            strBuffer.append(args[i]);
        }
        return strBuffer.toString().length() > 4096;
    }
}

