/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.saaj;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;

public class SAAJOutInterceptor
extends AbstractSoapInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(SAAJOutInterceptor.class);

    public SAAJOutInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        SOAPMessage saaj = message.getContent(SOAPMessage.class);
        if (saaj == null) {
            SoapVersion version = message.getVersion();
            try {
                MessageFactory factory = null;
                factory = version.getVersion() == 1.1 ? MessageFactory.newInstance() : MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
                SOAPMessage soapMessage = factory.createMessage();
                SOAPPart soapPart = soapMessage.getSOAPPart();
                W3CDOMStreamWriter writer = new W3CDOMStreamWriter((Document)soapPart);
                message.setContent(XMLStreamWriter.class, writer);
                message.setContent(SOAPMessage.class, soapMessage);
            }
            catch (SOAPException e) {
                throw new SoapFault(new Message("SOAPEXCEPTION", BUNDLE, new Object[0]), (Throwable)e, version.getSender());
            }
        }
        try {
            XMLStreamWriter dummyWriter = StaxUtils.getXMLOutputFactory().createXMLStreamWriter(new ByteArrayOutputStream());
            message.setContent(XMLStreamWriter.class, dummyWriter);
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        message.getInterceptorChain().add(new SAAJOutEndingInterceptor());
    }

    public class SAAJOutEndingInterceptor
    extends AbstractSoapInterceptor {
        public SAAJOutEndingInterceptor() {
            super(SAAJOutEndingInterceptor.class.getName(), "pre-protocol-ending");
        }

        public void handleMessage(SoapMessage message) throws Fault {
            SOAPMessage soapMessage = message.getContent(SOAPMessage.class);
            if (soapMessage != null) {
                OutputStream os = message.getContent(OutputStream.class);
                try {
                    this.setMessageContent(message, soapMessage);
                    soapMessage.writeTo(os);
                    os.flush();
                }
                catch (IOException e) {
                    throw new SoapFault(new Message("SOAPEXCEPTION", BUNDLE, new Object[0]), (Throwable)e, message.getVersion().getSender());
                }
                catch (SOAPException e) {
                    throw new SoapFault(new Message("SOAPEXCEPTION", BUNDLE, new Object[0]), (Throwable)e, message.getVersion().getSender());
                }
            }
        }

        private void setMessageContent(SoapMessage message, SOAPMessage soapMessage) throws SOAPException {
            if (soapMessage.getAttachments().hasNext()) {
                StringBuffer sb = new StringBuffer();
                for (String str : soapMessage.getMimeHeaders().getHeader("Content-Type")) {
                    sb.append(str);
                }
                String contentType = sb.toString();
                if (contentType != null && contentType.length() > 0) {
                    message.put("Content-Type", (Object)contentType);
                }
            }
        }
    }
}

