/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.common.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingXmlEventWriter
implements XMLStreamWriter {
    protected XMLEventFactory factory;
    List<XMLEvent> events = new ArrayList<XMLEvent>(1000);
    Stack<NSContext> contexts = new Stack();
    Stack<QName> elNames = new Stack();
    QName lastStart;
    NSContext curContext = new NSContext(null);

    public CachingXmlEventWriter() {
        this.factory = XMLEventFactory.newInstance();
    }

    protected void addEvent(XMLEvent event) {
        this.events.add(event);
    }

    public List<XMLEvent> getEvents() {
        return this.events;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.curContext;
    }

    @Override
    public String getPrefix(String ns) throws XMLStreamException {
        return this.curContext.getPrefix(ns);
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        return null;
    }

    @Override
    public void setNamespaceContext(NamespaceContext arg0) throws XMLStreamException {
        this.curContext = new NSContext(arg0);
    }

    @Override
    public void writeAttribute(String name, String value) throws XMLStreamException {
        this.addEvent(this.factory.createAttribute(name, value));
    }

    @Override
    public void writeAttribute(String pfx, String uri, String name, String value) throws XMLStreamException {
        this.addEvent(this.factory.createAttribute(pfx, uri, name, value));
    }

    @Override
    public void writeCData(String arg0) throws XMLStreamException {
        this.addEvent(this.factory.createCData(arg0));
    }

    @Override
    public void writeCharacters(String arg0) throws XMLStreamException {
        this.addEvent(this.factory.createCharacters(arg0));
    }

    @Override
    public void writeCharacters(char[] arg0, int arg1, int arg2) throws XMLStreamException {
        this.addEvent(this.factory.createCharacters(new String(arg0, arg1, arg2)));
    }

    @Override
    public void writeComment(String arg0) throws XMLStreamException {
        this.addEvent(this.factory.createComment(arg0));
    }

    @Override
    public void writeDTD(String arg0) throws XMLStreamException {
        this.addEvent(this.factory.createDTD(arg0));
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.addEvent(this.factory.createEndDocument());
    }

    @Override
    public void writeEntityRef(String arg0) throws XMLStreamException {
        this.addEvent(this.factory.createEntityReference(arg0, null));
    }

    @Override
    public void writeProcessingInstruction(String arg0) throws XMLStreamException {
        this.addEvent(this.factory.createProcessingInstruction(arg0, null));
    }

    @Override
    public void writeProcessingInstruction(String arg0, String arg1) throws XMLStreamException {
        this.addEvent(this.factory.createProcessingInstruction(arg0, arg1));
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.addEvent(this.factory.createStartDocument());
    }

    @Override
    public void writeStartDocument(String arg0) throws XMLStreamException {
        this.addEvent(this.factory.createStartDocument(arg0));
    }

    @Override
    public void writeStartDocument(String arg0, String arg1) throws XMLStreamException {
        this.addEvent(this.factory.createStartDocument(arg0, arg1));
    }

    @Override
    public void setDefaultNamespace(String ns) throws XMLStreamException {
        this.curContext.addNs("", ns);
    }

    @Override
    public void writeNamespace(String pfx, String ns) throws XMLStreamException {
        this.curContext.addNs(pfx, ns);
        if (StringUtils.isEmpty(pfx)) {
            this.addEvent(this.factory.createNamespace(ns));
        } else {
            this.addEvent(this.factory.createNamespace(pfx, ns));
        }
    }

    private String creatPrefix() {
        int count = 1;
        String pfx = "ns" + count;
        while (this.curContext.getNamespaceURI(pfx) != null) {
            pfx = "ns" + ++count;
        }
        return pfx;
    }

    @Override
    public void writeAttribute(String uri, String name, String value) throws XMLStreamException {
        if (!StringUtils.isEmpty(uri)) {
            String pfx = this.getPrefix(uri);
            if (pfx == null) {
                pfx = this.creatPrefix();
            }
            this.addEvent(this.factory.createAttribute(pfx, uri, name, value));
        } else {
            this.addEvent(this.factory.createAttribute(name, value));
        }
    }

    @Override
    public void setPrefix(String pfx, String uri) throws XMLStreamException {
        this.curContext.addNs(pfx, uri);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.addEvent(this.factory.createEndElement(this.lastStart, Collections.emptyList().iterator()));
        this.curContext = this.contexts.pop();
        this.lastStart = this.elNames.pop();
    }

    @Override
    public void writeDefaultNamespace(String ns) throws XMLStreamException {
        this.writeNamespace("", ns);
    }

    @Override
    public void writeEmptyElement(String name) throws XMLStreamException {
        this.writeStartElement(name);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String name, String ns) throws XMLStreamException {
        this.writeStartElement(name, ns);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String pfx, String name, String ns) throws XMLStreamException {
        this.writeStartElement(pfx, name, ns);
        this.writeEndElement();
    }

    @Override
    public void writeStartElement(String name) throws XMLStreamException {
        this.elNames.push(this.lastStart);
        this.contexts.push(this.curContext);
        this.curContext = new NSContext(this.curContext);
        this.lastStart = new QName(name);
        this.addEvent(this.factory.createStartElement(this.lastStart, Collections.EMPTY_SET.iterator(), Collections.EMPTY_SET.iterator()));
    }

    @Override
    public void writeStartElement(String name, String ns) throws XMLStreamException {
        this.elNames.push(this.lastStart);
        this.contexts.push(this.curContext);
        this.curContext = new NSContext(this.curContext);
        this.lastStart = new QName(ns, name);
        this.addEvent(this.factory.createStartElement(this.lastStart, Collections.EMPTY_SET.iterator(), Collections.EMPTY_SET.iterator()));
    }

    @Override
    public void writeStartElement(String pfx, String name, String ns) throws XMLStreamException {
        this.elNames.push(this.lastStart);
        this.contexts.push(this.curContext);
        this.curContext = new NSContext(this.curContext);
        this.lastStart = new QName(ns, name, pfx);
        this.addEvent(this.factory.createStartElement(this.lastStart, Collections.EMPTY_SET.iterator(), Collections.EMPTY_SET.iterator()));
    }

    private class NSContext
    implements NamespaceContext {
        NamespaceContext parent;
        Map<String, String> map = new HashMap<String, String>();

        public NSContext(NamespaceContext p) {
            this.parent = p;
        }

        public void addNs(String pfx, String ns) {
            this.map.put(ns, pfx);
        }

        public String getNamespaceURI(String prefix) {
            for (Map.Entry<String, String> e : this.map.entrySet()) {
                if (!e.getValue().equals(prefix)) continue;
                return e.getKey();
            }
            if (this.parent != null) {
                return this.parent.getNamespaceURI(prefix);
            }
            return null;
        }

        public String getPrefix(String namespaceURI) {
            String ret = this.map.get(namespaceURI);
            if (ret == null && this.parent != null) {
                return this.parent.getPrefix(namespaceURI);
            }
            return ret;
        }

        public Iterator getPrefixes(String namespaceURI) {
            String pfx = this.getPrefix(namespaceURI);
            if (pfx == null) {
                return Collections.emptyList().iterator();
            }
            return Collections.singleton(pfx).iterator();
        }
    }
}

