/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.writer.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProduceMime(value={"application/atom+xml", "application/atom+xml;type=entry", "application/json"})
@ConsumeMime(value={"application/atom+xml", "application/atom+xml;type=entry"})
@Provider
public class AtomEntryProvider
implements MessageBodyReader<Entry>,
MessageBodyWriter<Entry> {
    private static final Abdera ATOM_ENGINE = new Abdera();
    private static final String JSON_TYPE = "application/json";

    public long getSize(Entry feed) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations) {
        return Entry.class.isAssignableFrom(type);
    }

    public void writeTo(Entry entry, Class<?> clazz, Type type, Annotation[] a, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        if (JSON_TYPE.equals(mt.toString())) {
            Writer w = ATOM_ENGINE.getWriterFactory().getWriter("json");
            entry.writeTo(w, os);
        } else {
            entry.writeTo(os);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations) {
        return Entry.class.isAssignableFrom(type);
    }

    public Entry readFrom(Class<Entry> clazz, Type t, Annotation[] a, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        Document doc = ATOM_ENGINE.getParser().parse(is);
        return (Entry)doc.getRoot();
    }
}

