/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.continuations;

import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSContinuation
implements Continuation {
    static final String BOGUS_MESSAGE_SELECTOR = "org.apache.cxf.transports.jms.continuations=too-many";
    private static final Logger LOG = LogUtils.getL7dLogger(JMSContinuation.class);
    private Bus bus;
    private Message inMessage;
    private MessageObserver incomingObserver;
    private Collection<JMSContinuation> continuations;
    private DefaultMessageListenerContainer jmsListener;
    private JMSConfiguration jmsConfig;
    private String currentMessageSelector = "org.apache.cxf.transports.jms.continuations=too-many";
    private Object userObject;
    private boolean isNew = true;
    private boolean isPending;
    private boolean isResumed;
    private Timer timer = new Timer();

    public JMSContinuation(Bus b, Message m, MessageObserver observer, Collection<JMSContinuation> cList, DefaultMessageListenerContainer jmsListener, JMSConfiguration jmsConfig) {
        this.bus = b;
        this.inMessage = m;
        this.incomingObserver = observer;
        this.continuations = cList;
        this.jmsListener = jmsListener;
        this.jmsConfig = jmsConfig;
    }

    @Override
    public Object getObject() {
        return this.userObject;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public boolean isPending() {
        return this.isPending;
    }

    @Override
    public boolean isResumed() {
        return this.isResumed;
    }

    @Override
    public void reset() {
        this.cancelTimerTask();
        this.isNew = true;
        this.isPending = false;
        this.isResumed = false;
    }

    @Override
    public void resume() {
        if (this.isResumed || !this.isPending) {
            return;
        }
        this.isResumed = true;
        this.cancelTimerTask();
        this.doResume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doResume() {
        this.updateContinuations(true);
        BusFactory.setThreadDefaultBus(this.bus);
        try {
            this.incomingObserver.onMessage(this.inMessage);
        }
        finally {
            this.isPending = false;
            BusFactory.setThreadDefaultBus(null);
        }
    }

    @Override
    public void setObject(Object o) {
        this.userObject = o;
    }

    @Override
    public boolean suspend(long timeout) {
        if (this.isPending) {
            return false;
        }
        this.updateContinuations(false);
        this.isNew = false;
        this.isResumed = false;
        this.isPending = true;
        if (timeout > 0L) {
            this.createTimerTask(timeout);
        }
        throw new SuspendedInvocationException();
    }

    protected void createTimerTask(long timeout) {
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JMSContinuation jMSContinuation = JMSContinuation.this;
                synchronized (jMSContinuation) {
                    if (JMSContinuation.this.isPending) {
                        JMSContinuation.this.doResume();
                    }
                }
            }
        }, timeout);
    }

    protected void cancelTimerTask() {
        this.timer.cancel();
    }

    protected void updateContinuations(boolean remove) {
        this.modifyList(remove);
        if (this.jmsConfig.getMaxSuspendedContinuations() < 0 || this.jmsListener.getCacheLevel() >= 3) {
            return;
        }
        if (remove && !BOGUS_MESSAGE_SELECTOR.equals(this.currentMessageSelector)) {
            LOG.fine("A number of continuations has dropped below the limit of " + this.jmsConfig.getMaxSuspendedContinuations() + ", resetting JMS MessageSelector to " + this.currentMessageSelector);
            this.jmsListener.setMessageSelector(this.currentMessageSelector);
            this.currentMessageSelector = BOGUS_MESSAGE_SELECTOR;
        } else if (!remove && this.continuations.size() >= this.jmsConfig.getMaxSuspendedContinuations()) {
            this.currentMessageSelector = this.jmsListener.getMessageSelector();
            if (!BOGUS_MESSAGE_SELECTOR.equals(this.currentMessageSelector)) {
                LOG.fine("A number of continuations has reached the limit of " + this.jmsConfig.getMaxSuspendedContinuations() + ", setting JMS MessageSelector to " + BOGUS_MESSAGE_SELECTOR);
                this.jmsListener.setMessageSelector(BOGUS_MESSAGE_SELECTOR);
            }
        }
    }

    protected void modifyList(boolean remove) {
        if (remove) {
            this.continuations.remove(this);
        } else {
            this.continuations.add(this);
        }
    }

    String getCurrentMessageSelector() {
        return this.currentMessageSelector;
    }
}

