/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.io.AbstractThresholdOutputStream;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.http.AbstractHTTPTransportFactory;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transport.http.DigestAuthSupplier;
import org.apache.cxf.transport.http.HttpAuthSupplier;
import org.apache.cxf.transport.http.HttpBasicAuthSupplier;
import org.apache.cxf.transport.http.HttpURLConnectionFactory;
import org.apache.cxf.transport.http.MessageTrustDecider;
import org.apache.cxf.transport.http.UntrustedURLConnectionIOException;
import org.apache.cxf.transport.http.policy.PolicyUtils;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.version.Version;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPConduit
extends AbstractConduit
implements Configurable,
Assertor {
    public static final String KEY_HTTP_CONNECTION = "http.connection";
    private static final String KEY_VISITED_URLS = "VisitedURLs";
    private static final String KEY_AUTH_URLS = "AuthURLs";
    private static final Logger LOG = LogUtils.getL7dLogger(HTTPConduit.class);
    private static final String SC_HTTP_CONDUIT_SUFFIX = ".http-conduit";
    private static final byte[] BUFFER = new byte[1024];
    protected HttpURLConnectionFactory connectionFactory;
    private final Bus bus;
    private final EndpointInfo endpointInfo;
    private URL defaultEndpointURL;
    private boolean fromEndpointReferenceType;
    private Destination decoupledDestination;
    private MessageObserver decoupledObserver;
    private int decoupledDestinationRefCount;
    private HTTPClientPolicy clientSidePolicy;
    private AuthorizationPolicy authorizationPolicy;
    private ProxyAuthorizationPolicy proxyAuthorizationPolicy;
    private TLSClientParameters tlsClientParameters;
    private MessageTrustDecider trustDecider;
    private HttpAuthSupplier authSupplier;
    private boolean configFinalized;
    private Map<String, Cookie> sessionCookies = new ConcurrentHashMap<String, Cookie>();
    private boolean maintainSession;

    public HTTPConduit(Bus b, EndpointInfo ei) throws IOException {
        this(b, ei, null);
    }

    public HTTPConduit(Bus b, EndpointInfo ei, EndpointReferenceType t) throws IOException {
        super(HTTPConduit.getTargetReference(ei, t, b));
        this.bus = b;
        this.endpointInfo = ei;
        if (t != null) {
            this.fromEndpointReferenceType = true;
        }
        this.initializeConfig();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    public final String getConduitName() {
        return this.endpointInfo.getName() + SC_HTTP_CONDUIT_SUFFIX;
    }

    private void initializeConfig() {
        PolicyEngine pe = this.bus.getExtension(PolicyEngine.class);
        if (null != pe && pe.isEnabled() && this.endpointInfo.getService() != null) {
            this.clientSidePolicy = PolicyUtils.getClient(pe, this.endpointInfo, this);
        }
    }

    protected void finalizeConfig() {
        if (this.clientSidePolicy == null) {
            this.clientSidePolicy = this.endpointInfo.getTraversedExtensor(new HTTPClientPolicy(), HTTPClientPolicy.class);
        }
        if (this.authorizationPolicy == null) {
            this.authorizationPolicy = this.endpointInfo.getTraversedExtensor(new AuthorizationPolicy(), AuthorizationPolicy.class);
        }
        if (this.proxyAuthorizationPolicy == null) {
            this.proxyAuthorizationPolicy = this.endpointInfo.getTraversedExtensor(new ProxyAuthorizationPolicy(), ProxyAuthorizationPolicy.class);
        }
        if (this.tlsClientParameters == null) {
            this.tlsClientParameters = this.endpointInfo.getTraversedExtensor(null, TLSClientParameters.class);
        }
        if (this.trustDecider == null) {
            this.trustDecider = this.endpointInfo.getTraversedExtensor(null, MessageTrustDecider.class);
        }
        if (this.authSupplier == null) {
            this.authSupplier = this.endpointInfo.getTraversedExtensor(null, HttpAuthSupplier.class);
        }
        if (this.trustDecider == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "No Trust Decider configured for Conduit '" + this.getConduitName() + "'");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Message Trust Decider of class '" + this.trustDecider.getClass().getName() + "' with logical name of '" + this.trustDecider.getLogicalName() + "' has been configured for Conduit '" + this.getConduitName() + "'");
        }
        if (this.authSupplier == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "No Auth Supplier configured for Conduit '" + this.getConduitName() + "'");
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "HttpAuthSupplier of class '" + this.authSupplier.getClass().getName() + "' with logical name of '" + this.authSupplier.getLogicalName() + "' has been configured for Conduit '" + this.getConduitName() + "'");
        }
        if (this.tlsClientParameters != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been configured for TLS " + "keyManagers " + this.tlsClientParameters.getKeyManagers() + "trustManagers " + this.tlsClientParameters.getTrustManagers() + "secureRandom " + this.tlsClientParameters.getSecureRandom() + "Disable Common Name (CN) Check: " + this.tlsClientParameters.isDisableCNCheck());
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been configured for plain http.");
        }
        this.retrieveConnectionFactory();
        this.configFinalized = true;
    }

    public Map<String, Cookie> getCookies() {
        return this.sessionCookies;
    }

    protected synchronized void retrieveConnectionFactory() {
        this.connectionFactory = AbstractHTTPTransportFactory.getConnectionFactory(this);
    }

    protected synchronized void retrieveConnectionFactory(String url) {
        this.connectionFactory = AbstractHTTPTransportFactory.getConnectionFactory(this, url);
    }

    protected synchronized HttpURLConnectionFactory getConnectionFactory(URL url) {
        if (this.connectionFactory == null || !url.getProtocol().equals(this.connectionFactory.getProtocol())) {
            this.retrieveConnectionFactory(url.toString());
        }
        return this.connectionFactory;
    }

    @Override
    public void prepare(Message message) throws IOException {
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        URL currentURL = this.setupURL(message);
        boolean needToCacheRequest = false;
        HttpURLConnection connection = this.getConnectionFactory(currentURL).createConnection(this.getProxy(this.clientSidePolicy), currentURL);
        connection.setDoOutput(true);
        long timeout = this.clientSidePolicy.getConnectionTimeout();
        if (timeout > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        }
        connection.setConnectTimeout((int)timeout);
        timeout = this.clientSidePolicy.getReceiveTimeout();
        if (timeout > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        }
        connection.setReadTimeout((int)timeout);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        String httpRequestMethod = (String)message.get(Message.HTTP_REQUEST_METHOD);
        if (null != httpRequestMethod) {
            connection.setRequestMethod(httpRequestMethod);
        } else {
            connection.setRequestMethod("POST");
        }
        boolean isChunking = false;
        int chunkThreshold = 0;
        if (this.authSupplier != null) {
            String auth = this.authSupplier.getPreemptiveAuthorization(this, currentURL, message);
            if (auth == null || this.authSupplier.requiresRequestCaching()) {
                needToCacheRequest = true;
                isChunking = false;
                LOG.log(Level.FINE, "Auth Supplier, but no Premeptive User Pass or Digest auth (nonce may be stale) We must cache request.");
            }
            message.put("AUTH_VALUE", auth);
        }
        if (this.getClient().isAutoRedirect()) {
            needToCacheRequest = true;
            LOG.log(Level.FINE, "AutoRedirect is turned on.");
        }
        if (connection.getRequestMethod().equals("POST") && this.getClient().isAllowChunking()) {
            isChunking = true;
            chunkThreshold = this.getClient().getChunkingThreshold();
            if (chunkThreshold <= 0) {
                chunkThreshold = 0;
                connection.setChunkedStreamingMode(-1);
            }
        }
        this.maintainSession = Boolean.TRUE.equals((Boolean)message.get(Message.MAINTAIN_SESSION));
        if (this.maintainSession && this.sessionCookies.size() > 0) {
            List<Object> cookies = null;
            for (String s : headers.keySet()) {
                if (!"Cookie".equalsIgnoreCase(s)) continue;
                cookies = headers.remove(s);
                break;
            }
            cookies = cookies == null ? new ArrayList() : new ArrayList(cookies);
            headers.put("Cookie", cookies);
            for (Cookie c : this.sessionCookies.values()) {
                cookies.add(c.requestCookieHeader());
            }
        }
        message.put(KEY_HTTP_CONNECTION, connection);
        this.setHeadersByPolicy(message, currentURL, headers);
        message.setContent(OutputStream.class, new WrappedOutputStream(message, connection, needToCacheRequest, isChunking, chunkThreshold));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Message msg) throws IOException {
        InputStream in = msg.getContent(InputStream.class);
        try {
            if (in != null) {
                for (int count = 0; in.read(BUFFER) != -1 && count < 25; ++count) {
                }
            }
        }
        finally {
            super.close(msg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeTrustDecision(Message message) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)message.get(KEY_HTTP_CONNECTION);
        if (this.trustDecider != null) {
            try {
                connection.connect();
                this.trustDecider.establishTrust(this.getConduitName(), this.getConnectionFactory(connection.getURL()).getConnectionInfo(connection), message);
                if (!LOG.isLoggable(Level.FINE)) return;
                LOG.log(Level.FINE, "Trust Decider " + this.trustDecider.getLogicalName() + " considers Conduit " + this.getConduitName() + " trusted.");
                return;
            }
            catch (UntrustedURLConnectionIOException untrustedEx) {
                connection.disconnect();
                if (!LOG.isLoggable(Level.FINE)) throw untrustedEx;
                LOG.log(Level.FINE, "Trust Decider " + this.trustDecider.getLogicalName() + " considers Conduit " + this.getConduitName() + " untrusted.", untrustedEx);
                throw untrustedEx;
            }
        } else {
            if (!LOG.isLoggable(Level.FINE)) return;
            LOG.log(Level.FINE, "No Trust Decider for Conduit '" + this.getConduitName() + "'. An afirmative Trust Decision is assumed.");
        }
    }

    private URL setupURL(Message message) throws MalformedURLException {
        String result = (String)message.get(Message.ENDPOINT_ADDRESS);
        String pathInfo = (String)message.get(Message.PATH_INFO);
        String queryString = (String)message.get(Message.QUERY_STRING);
        if (result == null) {
            if (pathInfo == null && queryString == null) {
                return this.getURL();
            }
            result = this.getURL().toString();
        }
        if (null != pathInfo && !result.endsWith(pathInfo)) {
            result = result + pathInfo;
        }
        if (queryString != null) {
            result = result + "?" + queryString;
        }
        return new URL(result);
    }

    @Override
    public synchronized Destination getBackChannel() {
        if (this.decoupledDestination == null && this.getClient().getDecoupledEndpoint() != null) {
            this.setUpDecoupledDestination();
        }
        return this.decoupledDestination;
    }

    @Override
    public void close() {
        if (this.defaultEndpointURL != null) {
            try {
                URLConnection connect = this.defaultEndpointURL.openConnection();
                if (connect instanceof HttpURLConnection) {
                    ((HttpURLConnection)connect).disconnect();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.decoupledDestination != null) {
            this.releaseDecoupledDestination();
        }
    }

    protected String getAddress() throws MalformedURLException {
        if (this.defaultEndpointURL != null) {
            return this.defaultEndpointURL.toExternalForm();
        }
        if (this.fromEndpointReferenceType) {
            return this.getTarget().getAddress().getValue();
        }
        return this.endpointInfo.getAddress();
    }

    protected synchronized URL getURL() throws MalformedURLException {
        return this.getURL(true);
    }

    protected synchronized URL getURL(boolean createOnDemand) throws MalformedURLException {
        if (this.defaultEndpointURL == null && createOnDemand) {
            if (this.fromEndpointReferenceType && this.getTarget().getAddress().getValue() != null) {
                this.defaultEndpointURL = new URL(this.getTarget().getAddress().getValue());
                return this.defaultEndpointURL;
            }
            if (this.endpointInfo.getAddress() == null) {
                throw new MalformedURLException("Invalid address. Endpoint address cannot be null.");
            }
            this.defaultEndpointURL = new URL(this.endpointInfo.getAddress());
        }
        return this.defaultEndpointURL;
    }

    private Map<String, List<String>> getSetProtocolHeaders(Message message) {
        Map<String, List<String>> headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (null == headers) {
            headers = new LinkedHashMap();
        } else if (headers instanceof HashMap) {
            headers = new LinkedHashMap(headers);
        }
        message.put(Message.PROTOCOL_HEADERS, headers);
        return headers;
    }

    private void transferProtocolHeadersToURLConnection(Message message, URLConnection connection) {
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        for (String header : headers.keySet()) {
            List<String> headerList = headers.get(header);
            if ("Cookie".equalsIgnoreCase(header)) {
                for (String s : headerList) {
                    connection.addRequestProperty("Cookie", s);
                }
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < headerList.size(); ++i) {
                b.append(headerList.get(i));
                if (i + 1 >= headerList.size()) continue;
                b.append(',');
            }
            connection.setRequestProperty(header, b.toString());
        }
        if (!connection.getRequestProperties().containsKey("User-Agent")) {
            connection.addRequestProperty("User-Agent", Version.getCompleteVersionString());
        }
    }

    private void logProtocolHeaders(Level level, Message message) {
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        for (String header : headers.keySet()) {
            List<String> headerList = headers.get(header);
            for (String value : headerList) {
                LOG.log(level, header + ": " + value);
            }
        }
    }

    private void setURLRequestHeaders(Message message) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)message.get(KEY_HTTP_CONNECTION);
        String ct = (String)message.get("Content-Type");
        String enc = (String)message.get(Message.ENCODING);
        if (null != ct) {
            if (enc != null && ct.indexOf("charset=") == -1 && !ct.toLowerCase().contains("multipart/related")) {
                ct = ct + "; charset=" + enc;
            }
        } else {
            ct = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        connection.setRequestProperty("Content-Type", ct);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Sending " + connection.getRequestMethod() + " Message with Headers to " + connection.getURL() + " Conduit :" + this.getConduitName() + "\nContent-Type: " + ct + "\n");
            this.logProtocolHeaders(Level.FINE, message);
        }
        this.transferProtocolHeadersToURLConnection(message, connection);
    }

    private void setUpDecoupledDestination() {
        EndpointReferenceType reference = EndpointReferenceUtils.getEndpointReference(this.getClient().getDecoupledEndpoint());
        if (reference != null) {
            String decoupledAddress = reference.getAddress().getValue();
            LOG.info("creating decoupled endpoint: " + decoupledAddress);
            try {
                this.decoupledDestination = this.getDestination(decoupledAddress);
                this.duplicateDecoupledDestination();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "decoupled endpoint creation failed: ", e);
            }
        }
    }

    private Destination getDestination(String address) throws IOException {
        Destination destination = null;
        DestinationFactoryManager factoryManager = this.bus.getExtension(DestinationFactoryManager.class);
        DestinationFactory factory = factoryManager.getDestinationFactoryForUri(address);
        if (factory != null) {
            EndpointInfo ei = new EndpointInfo();
            ei.setAddress(address);
            destination = factory.getDestination(ei);
            this.decoupledObserver = new InterposedMessageObserver();
            destination.setMessageObserver(this.decoupledObserver);
        }
        return destination;
    }

    protected MessageObserver getDecoupledObserver() {
        return this.decoupledObserver;
    }

    private synchronized void duplicateDecoupledDestination() {
        ++this.decoupledDestinationRefCount;
    }

    private synchronized void releaseDecoupledDestination() {
        if (--this.decoupledDestinationRefCount == 0) {
            LOG.log(Level.FINE, "shutting down decoupled destination");
            this.decoupledDestination.shutdown();
            this.decoupledDestination.setMessageObserver(null);
        }
    }

    private boolean isOneway(Exchange exchange) {
        return exchange != null && exchange.isOneWay();
    }

    private boolean isDecoupled() {
        return this.decoupledDestination != null;
    }

    protected static InputStream getPartialResponse(HttpURLConnection connection, int responseCode) throws IOException {
        InputStream in = null;
        if (responseCode == 202 || responseCode == 200) {
            if (connection.getContentLength() > 0) {
                in = connection.getInputStream();
            } else if (HTTPConduit.hasChunkedResponse(connection) || HTTPConduit.hasEofTerminatedResponse(connection)) {
                in = HTTPConduit.getNonEmptyContent(connection);
            }
        }
        return in;
    }

    private static boolean hasChunkedResponse(HttpURLConnection connection) {
        return "chunked".equalsIgnoreCase(connection.getHeaderField("Transfer-Encoding"));
    }

    private static boolean hasEofTerminatedResponse(HttpURLConnection connection) {
        return "close".equalsIgnoreCase(connection.getHeaderField("Connection"));
    }

    private static InputStream getNonEmptyContent(HttpURLConnection connection) {
        PushbackInputStream in = null;
        try {
            PushbackInputStream pin = new PushbackInputStream(connection.getInputStream());
            int c = pin.read();
            if (c != -1) {
                pin.unread((byte)c);
                in = pin;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return in;
    }

    private Proxy getProxy(HTTPClientPolicy policy) {
        Proxy proxy = null;
        if (policy != null && policy.isSetProxyServer()) {
            proxy = new Proxy(Proxy.Type.valueOf(policy.getProxyServerType().toString()), new InetSocketAddress(policy.getProxyServer(), policy.getProxyServerPort()));
        }
        return proxy;
    }

    private void setHeadersByAuthorizationPolicy(Message message, URL url, Map<String, List<String>> headers) {
        AuthorizationPolicy authPolicy = this.getAuthorization();
        AuthorizationPolicy newPolicy = message.get(AuthorizationPolicy.class);
        String authString = null;
        if (this.authSupplier != null && (newPolicy == null || !"Basic".equals(newPolicy.getAuthorizationType()) && newPolicy.getAuthorization() == null)) {
            authString = (String)message.get("AUTH_VALUE");
            if (authString == null) {
                authString = this.authSupplier.getPreemptiveAuthorization(this, url, message);
            } else {
                message.remove("AUTH_VALUE");
            }
            if (authString != null) {
                headers.put("Authorization", HTTPConduit.createMutableList(authString));
            }
            return;
        }
        String userName = null;
        String passwd = null;
        if (null != newPolicy) {
            userName = newPolicy.getUserName();
            passwd = newPolicy.getPassword();
        }
        if (userName == null && authPolicy != null && authPolicy.isSetUserName()) {
            userName = authPolicy.getUserName();
        }
        if (userName != null) {
            if (passwd == null && authPolicy != null && authPolicy.isSetPassword()) {
                passwd = authPolicy.getPassword();
            }
            this.setBasicAuthHeader(userName, passwd, headers);
        } else if (authPolicy != null && authPolicy.isSetAuthorizationType() && authPolicy.isSetAuthorization()) {
            String type = authPolicy.getAuthorizationType();
            type = type + " ";
            type = type + authPolicy.getAuthorization();
            headers.put("Authorization", HTTPConduit.createMutableList(type));
        }
        ProxyAuthorizationPolicy proxyAuthPolicy = this.getProxyAuthorization();
        if (proxyAuthPolicy != null && proxyAuthPolicy.isSetUserName()) {
            userName = proxyAuthPolicy.getUserName();
            if (userName != null) {
                passwd = "";
                if (proxyAuthPolicy.isSetPassword()) {
                    passwd = proxyAuthPolicy.getPassword();
                }
                this.setProxyBasicAuthHeader(userName, passwd, headers);
            } else if (proxyAuthPolicy.isSetAuthorizationType() && proxyAuthPolicy.isSetAuthorization()) {
                String type = proxyAuthPolicy.getAuthorizationType();
                type = type + " ";
                type = type + proxyAuthPolicy.getAuthorization();
                headers.put("Proxy-Authorization", HTTPConduit.createMutableList(type));
            }
        }
    }

    private static List<String> createMutableList(String val) {
        return new ArrayList<String>(Arrays.asList(val));
    }

    private void setHeadersByClientPolicy(Message message, Map<String, List<String>> headers) {
        HTTPClientPolicy policy = this.getClient(message);
        if (policy == null) {
            return;
        }
        if (policy.isSetCacheControl()) {
            headers.put("Cache-Control", HTTPConduit.createMutableList(policy.getCacheControl().value()));
        }
        if (policy.isSetHost()) {
            headers.put("Host", HTTPConduit.createMutableList(policy.getHost()));
        }
        if (policy.isSetConnection()) {
            headers.put("Connection", HTTPConduit.createMutableList(policy.getConnection().value()));
        }
        if (policy.isSetAccept()) {
            headers.put("Accept", HTTPConduit.createMutableList(policy.getAccept()));
        } else if (!headers.containsKey("Accept")) {
            headers.put("Accept", HTTPConduit.createMutableList("*/*"));
        }
        if (policy.isSetAcceptEncoding()) {
            headers.put("Accept-Encoding", HTTPConduit.createMutableList(policy.getAcceptEncoding()));
        }
        if (policy.isSetAcceptLanguage()) {
            headers.put("Accept-Language", HTTPConduit.createMutableList(policy.getAcceptLanguage()));
        }
        if (policy.isSetContentType()) {
            message.put("Content-Type", policy.getContentType());
        }
        if (policy.isSetCookie()) {
            headers.put("Cookie", HTTPConduit.createMutableList(policy.getCookie()));
        }
        if (policy.isSetBrowserType()) {
            headers.put("BrowserType", HTTPConduit.createMutableList(policy.getBrowserType()));
        }
        if (policy.isSetReferer()) {
            headers.put("Referer", HTTPConduit.createMutableList(policy.getReferer()));
        }
    }

    private void setHeadersByPolicy(Message message, URL url, Map<String, List<String>> headers) {
        this.setHeadersByAuthorizationPolicy(message, url, headers);
        this.setHeadersByClientPolicy(message, headers);
    }

    @Override
    public String getBeanName() {
        if (this.endpointInfo.getName() != null) {
            return this.endpointInfo.getName().toString() + SC_HTTP_CONDUIT_SUFFIX;
        }
        return null;
    }

    public AuthorizationPolicy getAuthorization() {
        return this.authorizationPolicy;
    }

    public void setAuthorization(AuthorizationPolicy authorization) {
        this.authorizationPolicy = authorization;
    }

    public HTTPClientPolicy getClient(Message message) {
        return PolicyUtils.getClient(message, this.clientSidePolicy);
    }

    public HTTPClientPolicy getClient() {
        return this.clientSidePolicy;
    }

    public void setClient(HTTPClientPolicy client) {
        this.clientSidePolicy = client;
    }

    public ProxyAuthorizationPolicy getProxyAuthorization() {
        return this.proxyAuthorizationPolicy;
    }

    public void setProxyAuthorization(ProxyAuthorizationPolicy proxyAuthorization) {
        this.proxyAuthorizationPolicy = proxyAuthorization;
    }

    public TLSClientParameters getTlsClientParameters() {
        return this.tlsClientParameters;
    }

    public void setTlsClientParameters(TLSClientParameters params) {
        this.tlsClientParameters = params;
        if (this.tlsClientParameters != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been (re) configured for TLS " + "keyManagers " + this.tlsClientParameters.getKeyManagers() + "trustManagers " + this.tlsClientParameters.getTrustManagers() + "secureRandom " + this.tlsClientParameters.getSecureRandom());
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Conduit '" + this.getConduitName() + "' has been (re)configured for plain http.");
        }
        if (this.configFinalized) {
            this.retrieveConnectionFactory();
        }
    }

    public MessageTrustDecider getTrustDecider() {
        return this.trustDecider;
    }

    public void setTrustDecider(MessageTrustDecider decider) {
        this.trustDecider = decider;
    }

    public HttpAuthSupplier getAuthSupplier() {
        return this.authSupplier;
    }

    public void setAuthSupplier(HttpAuthSupplier supplier) {
        this.authSupplier = supplier;
    }

    private HttpURLConnection processRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 301: 
            case 302: {
                connection = this.redirectRetransmit(connection, message, cachedStream);
                break;
            }
            case 401: {
                connection = this.authorizationRetransmit(connection, message, cachedStream);
                break;
            }
        }
        return connection;
    }

    private HttpURLConnection redirectRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        if (!this.getClient().isAutoRedirect()) {
            return connection;
        }
        Set<String> visitedURLs = this.getSetVisitedURLs(message);
        String lastURL = connection.getURL().toString();
        visitedURLs.add(lastURL);
        String newURL = this.extractLocation(connection.getHeaderFields());
        if (newURL != null) {
            if (visitedURLs.contains(newURL)) {
                if (LOG.isLoggable(Level.INFO)) {
                    LOG.log(Level.INFO, "Redirect loop detected on Conduit \"" + this.getConduitName() + "\" on '" + newURL + "'");
                }
                throw new IOException("Redirect loop detected on Conduit \"" + this.getConduitName() + "\" on '" + newURL + "'");
            }
            Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
            headers.remove("Authorization");
            headers.remove("Proxy-Authorization");
            URL url = new URL(newURL);
            this.setHeadersByAuthorizationPolicy(message, url, headers);
            connection = this.retransmit(connection, url, message, cachedStream);
        }
        return connection;
    }

    private Set<String> getSetAuthoriationURLs(Message message) {
        HashSet authURLs = (HashSet)message.get(KEY_AUTH_URLS);
        if (authURLs == null) {
            authURLs = new HashSet();
            message.put(KEY_AUTH_URLS, authURLs);
        }
        return authURLs;
    }

    private Set<String> getSetVisitedURLs(Message message) {
        HashSet visitedURLs = (HashSet)message.get(KEY_VISITED_URLS);
        if (visitedURLs == null) {
            visitedURLs = new HashSet();
            message.put(KEY_VISITED_URLS, visitedURLs);
        }
        return visitedURLs;
    }

    private HttpURLConnection authorizationRetransmit(HttpURLConnection connection, Message message, CacheAndWriteOutputStream cachedStream) throws IOException {
        if (this.authSupplier == null) {
            String auth = connection.getHeaderField("WWW-Authenticate");
            if (auth.startsWith("Digest ")) {
                this.authSupplier = new DigestAuthSupplier();
            } else {
                return connection;
            }
        }
        URL currentURL = connection.getURL();
        String realm = this.extractAuthorizationRealm(connection.getHeaderFields());
        Set<String> authURLs = this.getSetAuthoriationURLs(message);
        if (authURLs.contains(currentURL.toString() + realm)) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Authorization loop detected on Conduit \"" + this.getConduitName() + "\" on URL \"" + "\" with realm \"" + realm + "\"");
            }
            throw new IOException("Authorization loop detected on Conduit \"" + this.getConduitName() + "\" on URL \"" + "\" with realm \"" + realm + "\"");
        }
        String up = this.authSupplier.getAuthorizationForRealm(this, currentURL, message, realm, connection.getHeaderField("WWW-Authenticate"));
        if (up == null) {
            return connection;
        }
        authURLs.add(currentURL.toString() + realm);
        Map<String, List<String>> headers = this.getSetProtocolHeaders(message);
        headers.put("Authorization", HTTPConduit.createMutableList(up));
        return this.retransmit(connection, currentURL, message, cachedStream);
    }

    private HttpURLConnection retransmit(HttpURLConnection connection, URL newURL, Message message, CacheAndWriteOutputStream stream) throws IOException {
        connection.disconnect();
        connection = this.getConnectionFactory(newURL).createConnection(this.getProxy(this.clientSidePolicy), newURL);
        connection.setDoOutput(true);
        connection.setConnectTimeout((int)this.getClient().getConnectionTimeout());
        connection.setReadTimeout((int)this.getClient().getReceiveTimeout());
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(false);
        String httpRequestMethod = (String)message.get(Message.HTTP_REQUEST_METHOD);
        if (null != httpRequestMethod) {
            connection.setRequestMethod(httpRequestMethod);
        } else {
            connection.setRequestMethod("POST");
        }
        message.put(KEY_HTTP_CONNECTION, connection);
        connection.setFixedLengthStreamingMode(stream.size());
        this.setURLRequestHeaders(message);
        this.makeTrustDecision(message);
        if (connection.getRequestMethod().equals("GET")) {
            return connection;
        }
        OutputStream out = connection.getOutputStream();
        stream.writeCacheTo(out);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Conduit \"" + this.getConduitName() + "\" Retransmit message to: " + connection.getURL() + ": " + new String(stream.getBytes()));
        }
        return connection;
    }

    private String extractAuthorizationRealm(Map<String, List<String>> headers) {
        List<String> auth = headers.get("WWW-Authenticate");
        if (auth != null) {
            for (String a : auth) {
                int idx = a.indexOf("realm=");
                if (idx == -1) continue;
                if ((a = a.substring(idx + 6)).charAt(0) == '\"') {
                    a = a.substring(1, a.indexOf(34, 1));
                } else if (a.contains(",")) {
                    a = a.substring(0, a.indexOf(44));
                }
                return a;
            }
        }
        return null;
    }

    private String extractLocation(Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> head : headers.entrySet()) {
            List<String> locs;
            if (!"Location".equalsIgnoreCase(head.getKey()) || (locs = head.getValue()) == null || locs.size() <= 0) continue;
            return locs.get(0);
        }
        return null;
    }

    private void setBasicAuthHeader(String userid, String password, Map<String, List<String>> headers) {
        String userpass = userid;
        userpass = userpass + ":";
        if (password != null) {
            userpass = userpass + password;
        }
        String token = Base64Utility.encode(userpass.getBytes());
        headers.put("Authorization", HTTPConduit.createMutableList("Basic " + token));
    }

    private void setProxyBasicAuthHeader(String userid, String password, Map<String, List<String>> headers) {
        String userpass = userid;
        userpass = userpass + ":";
        if (password != null) {
            userpass = userpass + password;
        }
        String token = Base64Utility.encode(userpass.getBytes());
        headers.put("Proxy-Authorization", HTTPConduit.createMutableList("Basic " + token));
    }

    @Override
    public void assertMessage(Message message) {
        PolicyUtils.assertClientPolicy(message, this.clientSidePolicy);
    }

    @Override
    public boolean canAssert(QName type) {
        return PolicyUtils.HTTPCLIENTPOLICY_ASSERTION_QNAME.equals(type);
    }

    @Deprecated
    public void setBasicAuthSupplier(HttpBasicAuthSupplier basicAuthSupplier) {
        this.setAuthSupplier(basicAuthSupplier);
    }

    protected class InterposedMessageObserver
    implements MessageObserver {
        protected InterposedMessageObserver() {
        }

        public void onMessage(Message inMessage) {
            inMessage.setExchange(new ExchangeImpl());
            inMessage.put("decoupled.channel.message", Boolean.TRUE);
            HTTPConduit.this.getSetProtocolHeaders(inMessage);
            inMessage.put(Message.RESPONSE_CODE, 200);
            inMessage.remove("HTTP.REQUEST");
            inMessage.remove("HTTP.RESPONSE");
            inMessage.remove("org.apache.cxf.async.post.response.dispatch");
            try {
                InputStream in = inMessage.getContent(InputStream.class);
                if (in != null) {
                    CachedOutputStream cos = new CachedOutputStream();
                    IOUtils.copy(in, cos);
                    inMessage.setContent(InputStream.class, cos.getInputStream());
                }
                HTTPConduit.this.incomingObserver.onMessage(inMessage);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected class WrappedOutputStream
    extends AbstractThresholdOutputStream {
        protected HttpURLConnection connection;
        protected boolean cachingForRetransmission;
        protected final boolean chunking;
        protected CacheAndWriteOutputStream cachedStream;
        protected Message outMessage;

        protected WrappedOutputStream(Message m, HttpURLConnection c, boolean possibleRetransmit, boolean isChunking, int chunkThreshold) {
            super(chunkThreshold);
            this.outMessage = m;
            this.connection = c;
            this.cachingForRetransmission = possibleRetransmit;
            this.chunking = isChunking;
        }

        public void thresholdNotReached() {
            if (this.chunking) {
                this.connection.setFixedLengthStreamingMode(this.buffer.size());
            }
        }

        public void thresholdReached() {
            if (this.chunking) {
                this.connection.setChunkedStreamingMode(-1);
            }
        }

        protected void onFirstWrite() throws IOException {
            try {
                this.handleHeadersTrustCaching();
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().contains("HTTPS hostname wrong:")) {
                    throw new IOException("The https URL hostname does not match the Common Name (CN) on the server certificate.  To disable this check (NOT recommended for production) set the CXF client TLS configuration property \"disableCNCheck\" to true.");
                }
                throw e;
            }
        }

        protected void handleHeadersTrustCaching() throws IOException {
            HTTPConduit.this.setURLRequestHeaders(this.outMessage);
            HTTPConduit.this.makeTrustDecision(this.outMessage);
            if (!"POST".equals(this.connection.getRequestMethod()) && !"PUT".equals(this.connection.getRequestMethod())) {
                return;
            }
            if (this.cachingForRetransmission) {
                this.cachedStream = new CacheAndWriteOutputStream(this.connection.getOutputStream());
                this.wrappedStream = this.cachedStream;
            } else {
                this.wrappedStream = this.connection.getOutputStream();
            }
        }

        public void flush() throws IOException {
            if (!this.chunking) {
                super.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.buffer != null && this.buffer.size() > 0) {
                this.thresholdNotReached();
                LoadingByteArrayOutputStream tmp = this.buffer;
                this.buffer = null;
                super.write(tmp.getRawBytes(), 0, tmp.size());
            }
            if (!this.written) {
                this.handleHeadersTrustCaching();
            }
            super.flush();
            if (!this.cachingForRetransmission) {
                super.close();
            } else {
                this.cachedStream.getOut().close();
                this.cachedStream.closeFlowthroughStream();
            }
            try {
                this.handleResponse();
            }
            finally {
                if (this.cachingForRetransmission && this.cachedStream != null) {
                    this.cachedStream.close();
                }
            }
        }

        protected void handleRetransmits() throws IOException {
            if (this.cachedStream != null) {
                int maxRetransmits;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Conduit \"" + HTTPConduit.this.getConduitName() + "\" Transmit cached message to: " + this.connection.getURL() + ": " + new String(this.cachedStream.getBytes()));
                }
                HttpURLConnection oldcon = this.connection;
                HTTPClientPolicy policy = HTTPConduit.this.getClient();
                int n = maxRetransmits = policy == null ? -1 : policy.getMaxRetransmits();
                if (maxRetransmits == 0) {
                    return;
                }
                int nretransmits = 0;
                this.connection = HTTPConduit.this.processRetransmit(this.connection, this.outMessage, this.cachedStream);
                while (this.connection != oldcon) {
                    oldcon = this.connection;
                    if (maxRetransmits >= 0 && ++nretransmits >= maxRetransmits) continue;
                    this.connection = HTTPConduit.this.processRetransmit(this.connection, this.outMessage, this.cachedStream);
                }
            }
        }

        protected void handleResponse() throws IOException {
            this.handleRetransmits();
            if (this.outMessage == null || this.outMessage.getExchange() == null || this.outMessage.getExchange().isSynchronous()) {
                this.handleResponseInternal();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            WrappedOutputStream.this.handleResponseInternal();
                        }
                        catch (IOException e) {
                            LOG.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                };
                WorkQueueManager mgr = this.outMessage.getExchange().get(Bus.class).getExtension(WorkQueueManager.class);
                AutomaticWorkQueue queue = mgr.getNamedWorkQueue("http-conduit");
                if (queue == null) {
                    queue = mgr.getAutomaticWorkQueue();
                }
                queue.execute(runnable);
            }
        }

        protected void handleResponseInternal() throws IOException {
            String normalizedEncoding;
            int responseCode = this.connection.getResponseCode();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Response Code: " + responseCode + " Conduit: " + HTTPConduit.this.getConduitName());
                LOG.fine("Content length: " + this.connection.getContentLength());
                Map<String, List<String>> headerFields = this.connection.getHeaderFields();
                if (null != headerFields) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("Header fields: ");
                    buf.append(System.getProperty("line.separator"));
                    for (String h : headerFields.keySet()) {
                        buf.append("    ");
                        buf.append(h);
                        buf.append(": ");
                        buf.append(headerFields.get(h));
                        buf.append(System.getProperty("line.separator"));
                    }
                    LOG.fine(buf.toString());
                }
            }
            if (responseCode == 404) {
                throw new IOException(this.connection.getResponseMessage());
            }
            Exchange exchange = this.outMessage.getExchange();
            InputStream in = null;
            if (HTTPConduit.this.isOneway(exchange) || HTTPConduit.this.isDecoupled()) {
                in = HTTPConduit.getPartialResponse(this.connection, responseCode);
                if (in == null) {
                    this.connection.getInputStream().close();
                    return;
                }
            } else {
                this.outMessage.removeContent(OutputStream.class);
                if (this.cachingForRetransmission) {
                    this.cachedStream.close();
                }
                this.cachedStream = null;
            }
            MessageImpl inMessage = new MessageImpl();
            inMessage.setExchange(exchange);
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (String key : this.connection.getHeaderFields().keySet()) {
                if (key == null) continue;
                headers.put(HttpHeaderHelper.getHeaderKey(key), this.connection.getHeaderFields().get(key));
            }
            inMessage.put(Message.PROTOCOL_HEADERS, headers);
            inMessage.put(Message.RESPONSE_CODE, responseCode);
            String ct = this.connection.getContentType();
            inMessage.put("Content-Type", ct);
            String charset = null;
            if (ct != null && ct.indexOf("charset") != -1 && (charset = ct.substring(ct.indexOf("charset") + 8)).indexOf(";") != -1) {
                charset = charset.substring(0, charset.indexOf(";"));
            }
            if ((normalizedEncoding = HttpHeaderHelper.mapCharset(charset)) == null) {
                String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, charset).toString();
                LOG.log(Level.WARNING, m);
                throw new IOException(m);
            }
            inMessage.put(Message.ENCODING, normalizedEncoding);
            if (HTTPConduit.this.maintainSession) {
                List<String> cookies = this.connection.getHeaderFields().get("Set-Cookie");
                Cookie.handleSetCookie(HTTPConduit.this.sessionCookies, cookies);
            }
            in = in == null ? (this.connection.getErrorStream() == null ? this.connection.getInputStream() : this.connection.getErrorStream()) : in;
            inMessage.setContent(InputStream.class, in);
            HTTPConduit.this.incomingObserver.onMessage(inMessage);
        }
    }
}

