/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import com.ibm.wsdl.extensions.soap.SOAPHeaderImpl;
import com.ibm.wsdl.extensions.soap.SOAPHeaderSerializer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.catalog.CatalogWSDLLocator;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.CacheMap;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.apache.cxf.service.model.ServiceSchemaInfo;
import org.apache.cxf.wsdl.JAXBExtensionHelper;
import org.apache.cxf.wsdl.WSDLConstants;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.SchemaSerializer;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLManagerImpl
implements WSDLManager {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLManagerImpl.class);
    private static final String EXTENSIONS_RESOURCE = "META-INF/cxf/extensions.xml";
    private static final String EXTENSIONS_RESOURCE_COMPAT = "META-INF/extensions.xml";
    final ExtensionRegistry registry;
    final WSDLFactory factory;
    final Map<Object, Definition> definitionsMap;
    final Map<Object, ServiceSchemaInfo> schemaCacheMap;
    private boolean disableSchemaCache;
    private Bus bus;

    public WSDLManagerImpl() throws BusException {
        try {
            this.factory = WSDLFactory.newInstance();
            this.registry = this.factory.newPopulatedExtensionRegistry();
            this.registry.registerSerializer(Types.class, WSDLConstants.QNAME_SCHEMA, (ExtensionSerializer)new SchemaSerializer());
            QName header = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
            this.registry.registerDeserializer(MIMEPart.class, header, (ExtensionDeserializer)new SOAPHeaderSerializer());
            this.registry.registerSerializer(MIMEPart.class, header, (ExtensionSerializer)new SOAPHeaderSerializer());
            this.registry.mapExtensionTypes(MIMEPart.class, header, SOAPHeaderImpl.class);
        }
        catch (WSDLException e) {
            throw new BusException(e);
        }
        this.definitionsMap = new CacheMap<Object, Definition>();
        this.schemaCacheMap = new CacheMap<Object, ServiceSchemaInfo>();
        this.registerInitialExtensions();
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension(this, WSDLManager.class);
        }
    }

    @Override
    public WSDLFactory getWSDLFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Object, Definition> getDefinitions() {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            return Collections.unmodifiableMap(this.definitionsMap);
        }
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(URL url) throws WSDLException {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            if (this.definitionsMap.containsKey(url)) {
                return this.definitionsMap.get(url);
            }
        }
        Definition def = this.loadDefinition(url.toString());
        Map<Object, Definition> map2 = this.definitionsMap;
        synchronized (map2) {
            this.definitionsMap.put(url, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(String url) throws WSDLException {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            if (this.definitionsMap.containsKey(url)) {
                return this.definitionsMap.get(url);
            }
        }
        return this.loadDefinition(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Definition getDefinition(Element el) throws WSDLException {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            if (this.definitionsMap.containsKey(el)) {
                return this.definitionsMap.get(el);
            }
        }
        WSDLReader reader = this.factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setExtensionRegistry(this.registry);
        Definition def = reader.readWSDL("", el);
        Map<Object, Definition> map2 = this.definitionsMap;
        synchronized (map2) {
            this.definitionsMap.put(el, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDefinition(Object key, Definition wsdl) {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            this.definitionsMap.put(key, wsdl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Definition loadDefinition(String url) throws WSDLException {
        WSDLReader reader = this.factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        reader.setExtensionRegistry(this.registry);
        CatalogWSDLLocator catLocator = new CatalogWSDLLocator(url, this.bus);
        ResourceManagerWSDLLocator wsdlLocator = new ResourceManagerWSDLLocator(url, catLocator, this.bus);
        Definition def = reader.readWSDL((WSDLLocator)wsdlLocator);
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            this.definitionsMap.put(url, def);
        }
        return def;
    }

    private void registerInitialExtensions() throws BusException {
        this.registerInitialExtensions(EXTENSIONS_RESOURCE_COMPAT);
        this.registerInitialExtensions(EXTENSIONS_RESOURCE);
    }

    private void registerInitialExtensions(String resource) throws BusException {
        Properties initialExtensions = null;
        try {
            initialExtensions = PropertiesLoaderUtils.loadAllProperties(resource, Thread.currentThread().getContextClassLoader());
        }
        catch (IOException ex) {
            throw new BusException(ex);
        }
        Iterator<Object> it = initialExtensions.keySet().iterator();
        while (it.hasNext()) {
            StringTokenizer st = new StringTokenizer(initialExtensions.getProperty((String)it.next()), "=");
            String parentType = st.nextToken();
            String elementType = st.nextToken();
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Registering extension: " + elementType + " for parent: " + parentType);
                }
                JAXBExtensionHelper.addExtensions(this.registry, parentType, elementType);
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
            catch (JAXBException ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceSchemaInfo getSchemasForDefinition(Definition wsdl) {
        if (this.disableSchemaCache) {
            return null;
        }
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            for (Map.Entry<Object, Definition> e : this.definitionsMap.entrySet()) {
                ServiceSchemaInfo info;
                if (e.getValue() != wsdl || (info = this.schemaCacheMap.get(e.getKey())) == null) continue;
                return info;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putSchemasForDefinition(Definition wsdl, ServiceSchemaInfo schemas) {
        if (!this.disableSchemaCache) {
            Map<Object, Definition> map = this.definitionsMap;
            synchronized (map) {
                for (Map.Entry<Object, Definition> e : this.definitionsMap.entrySet()) {
                    if (e.getValue() != wsdl) continue;
                    this.schemaCacheMap.put(e.getKey(), schemas);
                }
            }
        }
    }

    public boolean isDisableSchemaCache() {
        return this.disableSchemaCache;
    }

    public void setDisableSchemaCache(boolean disableSchemaCache) {
        this.disableSchemaCache = disableSchemaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDefinition(Definition wsdl) {
        Map<Object, Definition> map = this.definitionsMap;
        synchronized (map) {
            ArrayList<Object> keys = new ArrayList<Object>();
            for (Map.Entry<Object, Definition> entry : this.definitionsMap.entrySet()) {
                if (entry.getValue() != wsdl) continue;
                keys.add(entry.getKey());
            }
            for (Map.Entry<Object, Object> entry : keys) {
                this.definitionsMap.remove(entry);
                this.schemaCacheMap.remove(entry);
            }
        }
    }
}

