/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSOutputStream;
import org.apache.cxf.transport.jms.JMSUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

public class JMSConduit
extends AbstractConduit
implements JMSExchangeSender,
MessageListener {
    static final Logger LOG = LogUtils.getL7dLogger(JMSConduit.class);
    private static final String CORRELATED = JMSConduit.class.getName() + ".correlated";
    private EndpointInfo endpointInfo;
    private JMSConfiguration jmsConfig;
    private Map<String, Exchange> correlationMap;
    private DefaultMessageListenerContainer jmsListener;
    private String conduitId;
    private int messageCount;

    public JMSConduit(EndpointInfo endpointInfo, EndpointReferenceType target, JMSConfiguration jmsConfig) {
        super(target);
        this.jmsConfig = jmsConfig;
        this.endpointInfo = endpointInfo;
        this.correlationMap = new ConcurrentHashMap<String, Exchange>();
        this.conduitId = UUID.randomUUID().toString();
        this.messageCount = 0;
    }

    private synchronized String createCorrelationId() {
        ++this.messageCount;
        return this.conduitId + "_" + this.messageCount;
    }

    public void prepare(Message message) throws IOException {
        String name = this.endpointInfo.getName().toString() + ".jms-conduit";
        org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INSUFFICIENT_CONFIGURATION_CONDUIT", LOG, name);
        this.jmsConfig.ensureProperlyConfigured(msg);
        boolean isTextPayload = "text".equals(this.jmsConfig.getMessageType());
        JMSOutputStream out = new JMSOutputStream(this, message.getExchange(), isTextPayload);
        message.setContent(OutputStream.class, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendExchange(Exchange exchange, final Object request) {
        LOG.log(Level.FINE, "JMSConduit send message");
        final Message outMessage = exchange.getOutMessage();
        if (outMessage == null) {
            throw new RuntimeException("Exchange to be sent has no outMessage");
        }
        JMSMessageHeadersType headers = (JMSMessageHeadersType)outMessage.get("org.apache.cxf.jms.client.request.headers");
        JmsTemplate jmsTemplate = JMSFactory.createJmsTemplate(this.jmsConfig, headers);
        if (!exchange.isOneWay() && this.jmsListener == null) {
            this.jmsListener = JMSFactory.createJmsListener(this.jmsConfig, this, this.jmsConfig.getReplyDestination(), this.conduitId);
        }
        final Destination replyTo = exchange.isOneWay() ? null : this.jmsListener.getDestination();
        final String correlationId = headers != null && headers.isSetJMSCorrelationID() ? headers.getJMSCorrelationID() : this.createCorrelationId();
        MessageCreator messageCreator = new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                String messageType = JMSConduit.this.jmsConfig.getMessageType();
                javax.jms.Message jmsMessage = JMSUtils.buildJMSMessageFromCXFMessage(outMessage, request, messageType, session, replyTo, correlationId);
                LOG.log(Level.FINE, "client sending request: ", jmsMessage);
                return jmsMessage;
            }
        };
        if (!exchange.isOneWay()) {
            Exchange exchange2 = exchange;
            synchronized (exchange2) {
                this.correlationMap.put(correlationId, exchange);
                jmsTemplate.send(this.jmsConfig.getTargetDestination(), messageCreator);
                if (exchange.isSynchronous()) {
                    try {
                        exchange.wait(jmsTemplate.getReceiveTimeout());
                    }
                    catch (InterruptedException e) {
                        this.correlationMap.remove(correlationId);
                        throw new RuntimeException(e);
                    }
                    this.correlationMap.remove(correlationId);
                    if (exchange.get(CORRELATED) == null) {
                        throw new RuntimeException("Timeout receiving message with correlationId " + correlationId);
                    }
                }
            }
        }
        jmsTemplate.send(this.jmsConfig.getTargetDestination(), messageCreator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(javax.jms.Message jmsMessage) {
        String correlationId;
        try {
            correlationId = jmsMessage.getJMSCorrelationID();
        }
        catch (JMSException e) {
            throw JmsUtils.convertJmsAccessException((JMSException)e);
        }
        Exchange exchange = this.correlationMap.remove(correlationId);
        if (exchange == null) {
            LOG.log(Level.WARNING, "Could not correlate message with correlationId " + correlationId);
            return;
        }
        MessageImpl inMessage = new MessageImpl();
        exchange.setInMessage(inMessage);
        LOG.log(Level.FINE, "client received reply: ", jmsMessage);
        try {
            JMSUtils.populateIncomingContext(jmsMessage, inMessage, "org.apache.cxf.jms.client.response.headers");
            byte[] response = JMSUtils.retrievePayload(jmsMessage, (String)inMessage.get(Message.ENCODING));
            LOG.log(Level.FINE, "The Response Message payload is : [" + response + "]");
            inMessage.setContent(InputStream.class, new ByteArrayInputStream(response));
            if (exchange.isSynchronous()) {
                Exchange exchange2 = exchange;
                synchronized (exchange2) {
                    exchange.put(CORRELATED, Boolean.TRUE);
                    exchange.notifyAll();
                }
            }
            if (this.incomingObserver != null) {
                this.incomingObserver.onMessage(exchange.getInMessage());
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().log(Level.WARNING, "can't get the right encoding information " + ex);
        }
    }

    public void close() {
        if (this.jmsListener != null) {
            this.jmsListener.shutdown();
        }
        LOG.log(Level.FINE, "JMSConduit closed ");
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected void finalize() throws Throwable {
        if (this.jmsListener != null) {
            this.jmsListener.shutdown();
        }
        super.finalize();
    }
}

