/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;

public abstract class BusFactory {
    public static final String BUS_FACTORY_PROPERTY_NAME = "org.apache.cxf.bus.factory";
    public static final String DEFAULT_BUS_FACTORY = "org.apache.cxf.bus.CXFBusFactory";
    protected static Bus defaultBus;
    protected static ThreadLocal<Bus> localBus;
    private static final Logger LOG;

    public abstract Bus createBus();

    public static synchronized Bus getDefaultBus() {
        return BusFactory.getDefaultBus(true);
    }

    public static synchronized Bus getDefaultBus(boolean createIfNeeded) {
        if (defaultBus == null && createIfNeeded) {
            defaultBus = BusFactory.newInstance().createBus();
        }
        return defaultBus;
    }

    public static synchronized void setDefaultBus(Bus bus) {
        defaultBus = bus;
        BusFactory.setThreadDefaultBus(bus);
    }

    public static void setThreadDefaultBus(Bus bus) {
        localBus.set(bus);
    }

    public static Bus getThreadDefaultBus() {
        return BusFactory.getThreadDefaultBus(true);
    }

    public static Bus getThreadDefaultBus(boolean createIfNeeded) {
        if (createIfNeeded && localBus.get() == null) {
            Bus b = BusFactory.getDefaultBus(createIfNeeded);
            localBus.set(b);
        }
        return localBus.get();
    }

    public static synchronized boolean possiblySetDefaultBus(Bus bus) {
        if (localBus.get() == null) {
            localBus.set(bus);
        }
        if (defaultBus == null) {
            defaultBus = bus;
            return true;
        }
        return false;
    }

    public static BusFactory newInstance() {
        return BusFactory.newInstance(null);
    }

    public static BusFactory newInstance(String className) {
        ClassLoader loader;
        BusFactory instance = null;
        if (className == null && (className = BusFactory.getBusFactoryClass(loader = Thread.currentThread().getContextClassLoader())) == null && loader != BusFactory.class.getClassLoader()) {
            className = BusFactory.getBusFactoryClass(BusFactory.class.getClassLoader());
        }
        if (className == null) {
            className = DEFAULT_BUS_FACTORY;
        }
        try {
            Class<BusFactory> busFactoryClass = ClassLoaderUtils.loadClass(className, BusFactory.class).asSubclass(BusFactory.class);
            instance = busFactoryClass.newInstance();
        }
        catch (Exception ex) {
            LogUtils.log(LOG, Level.SEVERE, "BUS_FACTORY_INSTANTIATION_EXC", ex);
            throw new RuntimeException(ex);
        }
        return instance;
    }

    protected void initializeBus(Bus bus) {
    }

    private static String getBusFactoryClass(ClassLoader classLoader) {
        String busFactoryClass = null;
        String busFactoryCondition = null;
        busFactoryClass = System.getProperty(BUS_FACTORY_PROPERTY_NAME);
        if (BusFactory.isValidBusFactoryClass(busFactoryClass)) {
            return busFactoryClass;
        }
        try {
            String serviceId = "META-INF/services/org.apache.cxf.bus.factory";
            InputStream is = null;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if ((is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId)) == null) {
                serviceId = "META-INF/cxf/org.apache.cxf.bus.factory";
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            }
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                busFactoryClass = rd.readLine();
                busFactoryCondition = rd.readLine();
                rd.close();
            }
            if (BusFactory.isValidBusFactoryClass(busFactoryClass)) {
                if (busFactoryCondition != null) {
                    try {
                        classLoader.loadClass(busFactoryCondition);
                        return busFactoryClass;
                    }
                    catch (ClassNotFoundException e) {
                        return DEFAULT_BUS_FACTORY;
                    }
                }
                return busFactoryClass;
            }
            return busFactoryClass;
        }
        catch (Exception ex) {
            LogUtils.log(LOG, Level.SEVERE, "FAILED_TO_DETERMINE_BUS_FACTORY_EXC", ex);
            return busFactoryClass;
        }
    }

    private static boolean isValidBusFactoryClass(String busFactoryClassName) {
        return busFactoryClassName != null && !"".equals(busFactoryClassName);
    }

    static {
        localBus = new ThreadLocal();
        LOG = LogUtils.getL7dLogger(BusFactory.class, "APIMessages");
    }
}

