/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator.wsdl11.annotator;

import java.lang.annotation.Annotation;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaField;

public class WrapperBeanFieldAnnotator
implements Annotator {
    public void annotate(JavaAnnotatable field) {
        JavaField jField = null;
        if (!(field instanceof JavaField)) {
            throw new RuntimeException("WrapperBeanFiledAnnotator expect JavaField as input");
        }
        jField = (JavaField)field;
        String rawName = jField.getRawName();
        JAnnotation xmlElementAnnotation = new JAnnotation(XmlElement.class);
        xmlElementAnnotation.addElement(new JAnnotationElement("name", rawName));
        if (!StringUtils.isEmpty(jField.getTargetNamespace())) {
            xmlElementAnnotation.addElement(new JAnnotationElement("namespace", jField.getTargetNamespace()));
        }
        jField.addAnnotation(xmlElementAnnotation);
        for (Annotation ann : jField.getJaxbAnnotaions()) {
            JAnnotation jaxbAnn;
            if (ann instanceof XmlMimeType) {
                JAnnotation mimeAnno = new JAnnotation(XmlMimeType.class);
                mimeAnno.addElement(new JAnnotationElement("value", ((XmlMimeType)ann).value()));
                jField.addAnnotation(mimeAnno);
                continue;
            }
            if (ann instanceof XmlJavaTypeAdapter) {
                jaxbAnn = new JAnnotation(XmlJavaTypeAdapter.class);
                jaxbAnn.addElement(new JAnnotationElement("value", ((XmlJavaTypeAdapter)ann).value()));
                jaxbAnn.addElement(new JAnnotationElement("type", ((XmlJavaTypeAdapter)ann).type()));
                jField.addAnnotation(jaxbAnn);
                continue;
            }
            if (ann instanceof XmlAttachmentRef) {
                jaxbAnn = new JAnnotation(XmlAttachmentRef.class);
                jField.addAnnotation(jaxbAnn);
                continue;
            }
            if (!(ann instanceof XmlList)) continue;
            jaxbAnn = new JAnnotation(XmlList.class);
            jField.addAnnotation(jaxbAnn);
        }
    }
}

