/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.lang.reflect.Method;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceConfiguration;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;

public class WebServiceProviderConfiguration
extends JaxWsServiceConfiguration {
    private JaxWsImplementorInfo implInfo;

    public Boolean isOperation(Method method) {
        return method.getName().equals("invoke") && method.getParameterTypes().length == 1 && (Source.class.isAssignableFrom(method.getParameterTypes()[0]) || SOAPMessage.class.isAssignableFrom(method.getParameterTypes()[0]) || DataSource.class.isAssignableFrom(method.getParameterTypes()[0]));
    }

    public void setServiceFactory(ReflectionServiceFactoryBean serviceFactory) {
        super.setServiceFactory(serviceFactory);
        this.implInfo = ((JaxWsServiceFactoryBean)serviceFactory).getJaxWsImplementorInfo();
    }

    public String getServiceName() {
        QName service = this.implInfo.getServiceName();
        if (service == null) {
            return null;
        }
        return service.getLocalPart();
    }

    public String getServiceNamespace() {
        QName service = this.implInfo.getServiceName();
        if (service == null) {
            return null;
        }
        return service.getNamespaceURI();
    }

    public QName getEndpointName() {
        return this.implInfo.getEndpointName();
    }

    public String getWsdlURL() {
        String wsdlLocation = this.implInfo.getWsdlLocation();
        if (wsdlLocation != null && wsdlLocation.length() > 0) {
            return wsdlLocation;
        }
        return null;
    }

    public Boolean isWrapped(Method m) {
        return true;
    }
}

