/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXBProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractJAXBProvider.class);
    private static final String CHARSET_PARAMETER = "charset";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static Map<String, JAXBContext> packageContexts = new WeakHashMap<String, JAXBContext>();
    private static Map<Class<?>, JAXBContext> classContexts = new WeakHashMap();
    @Context
    protected ContextResolver<JAXBContext> resolver;
    private Schema schema;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns) {
        return this.isSupported(type, genericType, anns) || AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class) != null;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations) {
        return this.isSupported(type, genericType, annotations);
    }

    public void setSchemas(List<String> locations) {
        this.schema = this.createSchema(locations);
    }

    public long getSize(Object o) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JAXBContext getJAXBContext(Class<?> type, Type genericType) throws JAXBException {
        JAXBContext context;
        if (this.resolver != null && (context = (JAXBContext)this.resolver.getContext(type)) != null) {
            return context;
        }
        context = classContexts;
        synchronized (context) {
            JAXBContext context2 = classContexts.get(type);
            if (context2 != null) {
                return context2;
            }
        }
        context = this.getPackageContext(type);
        if (context == null && type != genericType) {
            context = this.getPackageContext(InjectionUtils.getActualType(genericType));
        }
        return context != null ? context : this.getClassContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getClassContext(Class<?> type) throws JAXBException {
        Map<Class<?>, JAXBContext> map = classContexts;
        synchronized (map) {
            JAXBContext context = classContexts.get(type);
            if (context == null) {
                context = JAXBContext.newInstance((Class[])new Class[]{type});
                classContexts.put(type, context);
            }
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getPackageContext(Class<?> type) {
        if (type == null) {
            return null;
        }
        Map<String, JAXBContext> map = packageContexts;
        synchronized (map) {
            String packageName = PackageUtils.getPackageName(type);
            JAXBContext context = packageContexts.get(packageName);
            if (context == null) {
                try {
                    context = JAXBContext.newInstance((String)packageName, (ClassLoader)type.getClassLoader());
                    packageContexts.put(packageName, context);
                    return context;
                }
                catch (JAXBException ex) {
                    LOG.fine("Error creating a JAXBContext using ObjectFactory : " + ex.getMessage());
                    return null;
                }
            }
        }
        return null;
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] annotations) {
        return type.getAnnotation(XmlRootElement.class) != null || JAXBElement.class.isAssignableFrom(type) || this.objectFactoryForClass(type) || type != genericType && this.objectFactoryForType(genericType);
    }

    private boolean objectFactoryForClass(Class<?> type) {
        try {
            return type.getClassLoader().loadClass(PackageUtils.getPackageName(type) + ".ObjectFactory") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean objectFactoryForType(Type genericType) {
        return this.objectFactoryForClass(InjectionUtils.getActualType(genericType));
    }

    protected Unmarshaller createUnmarshaller(Class<?> cls, Type genericType) throws JAXBException {
        JAXBContext context = this.getJAXBContext(cls, genericType);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        return unmarshaller;
    }

    protected Marshaller createMarshaller(Object obj, Class<?> cls, Type genericType, MediaType m) throws JAXBException {
        Class objClazz = JAXBElement.class.isAssignableFrom(cls) ? ((JAXBElement)obj).getDeclaredType() : cls;
        JAXBContext context = this.getJAXBContext(objClazz, genericType);
        Marshaller marshaller = context.createMarshaller();
        String enc = (String)m.getParameters().get(CHARSET_PARAMETER);
        if (enc != null) {
            marshaller.setProperty("jaxb.encoding", (Object)enc);
        }
        return marshaller;
    }

    protected Class<?> getActualType(Class<?> type, Type genericType) {
        Class<?> theType = null;
        theType = JAXBElement.class.isAssignableFrom(type) ? InjectionUtils.getActualType(genericType) : type;
        return theType;
    }

    protected Object checkAdapter(Object obj, Annotation[] anns) {
        XmlJavaTypeAdapter typeAdapter = AnnotationUtils.getAnnotation(anns, XmlJavaTypeAdapter.class);
        if (typeAdapter != null) {
            try {
                XmlAdapter xmlAdapter = (XmlAdapter)typeAdapter.value().newInstance();
                return xmlAdapter.marshal(obj);
            }
            catch (Exception ex) {
                LOG.warning("Problem using the XmlJavaTypeAdapter");
                ex.printStackTrace();
            }
        }
        return obj;
    }

    private Schema createSchema(List<String> locations) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema s = null;
        try {
            ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
            for (String loc : locations) {
                InputStream is = null;
                if (loc.startsWith(CLASSPATH_PREFIX)) {
                    String path = loc.substring(CLASSPATH_PREFIX.length() + 1);
                    is = this.getClass().getClassLoader().getResourceAsStream(path);
                    if (is == null) {
                        LOG.warning("No schema resource " + loc + " is available on classpath");
                        return null;
                    }
                } else {
                    File f = new File(loc);
                    if (!f.exists()) {
                        LOG.warning("No schema resource " + loc + " is available on local disk");
                        return null;
                    }
                    is = new FileInputStream(f);
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                sources.add(new StreamSource(r));
            }
            s = factory.newSchema(sources.toArray(new Source[0]));
        }
        catch (Exception ex) {
            LOG.warning("Validation will be disabled, failed to create schema : " + ex.getMessage());
        }
        return s;
    }

    protected Schema getSchema() {
        return this.schema;
    }
}

