/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.Anonarray;
import org.apache.cxf.binding.corba.wsdl.Array;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.tools.corba.common.ReferenceConstants;
import org.apache.cxf.tools.corba.processors.idl.ArrayDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class ArrayVisitor
extends VisitorBase {
    private static final String ELEMENT_NAME = "item";
    private AST identifierNode;

    public ArrayVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor, AST identifierNodeRef, Scope fqName) {
        super(scope, defn, schemaRef, wsdlVisitor);
        this.setFullyQualifiedName(fqName);
        this.identifierNode = identifierNodeRef;
    }

    public static boolean accept(AST node) {
        boolean result = false;
        AST sizeNode = node.getFirstChild();
        if (sizeNode != null) {
            result = true;
            while (sizeNode != null && result) {
                String s = sizeNode.toString();
                for (int j = 0; j < s.length(); ++j) {
                    if (Character.isDigit(s.charAt(j))) continue;
                    result = false;
                }
                sizeNode = sizeNode.getNextSibling();
            }
        }
        return result;
    }

    public void visit(AST node) {
        AST firstSizeNode = node.getFirstChild();
        AST nextSizeNode = firstSizeNode.getNextSibling();
        Types result = null;
        if (nextSizeNode != null) {
            result = this.doAnonarray(nextSizeNode, this.getSchemaType(), this.getCorbaType());
        } else {
            result = new Types();
            result.setSchemaType(this.getSchemaType());
            result.setCorbaType(this.getCorbaType());
            result.setFullyQualifiedName(this.getFullyQualifiedName());
        }
        Long size = new Long(firstSizeNode.toString());
        XmlSchemaComplexType stype = null;
        CorbaTypeImpl ctype = null;
        if (this.identifierNode != null) {
            Scope scopedName = this.getScope();
            stype = result.getSchemaType() != null ? this.generateSchemaArray(scopedName, size, result.getSchemaType(), result.getFullyQualifiedName()) : this.generateSchemaArray(scopedName, size, null, result.getFullyQualifiedName());
            ctype = result.getCorbaType() != null ? this.generateCorbaArray(scopedName, size, result.getCorbaType(), (XmlSchemaType)stype, this.getFullyQualifiedName()) : this.generateCorbaArray(scopedName, size, null, (XmlSchemaType)stype, this.getFullyQualifiedName());
        } else {
            Scope scopedName = TypesUtils.generateAnonymousScopedName(this.getScope(), this.schema);
            stype = result.getSchemaType() != null ? this.generateSchemaArray(scopedName, size, result.getSchemaType(), this.getFullyQualifiedName()) : this.generateSchemaArray(scopedName, size, null, this.getFullyQualifiedName());
            ctype = result.getCorbaType() != null ? this.generateCorbaAnonarray(scopedName.toString(), size, result.getCorbaType(), (XmlSchemaType)stype, this.getFullyQualifiedName()) : this.generateCorbaAnonarray(scopedName.toString(), size, null, (XmlSchemaType)stype, this.getFullyQualifiedName());
        }
        this.schema.getItems().add((XmlSchemaObject)stype);
        this.schema.addType((XmlSchemaType)stype);
        this.typeMap.getStructOrExceptionOrUnion().add(ctype);
        this.setSchemaType((XmlSchemaType)stype);
        this.setCorbaType(ctype);
    }

    private Types doAnonarray(AST node, XmlSchemaType stype, CorbaTypeImpl ctype) {
        Types result = new Types();
        if (node != null) {
            AST next = node.getNextSibling();
            result = this.doAnonarray(next, stype, ctype);
            Scope scopedName = TypesUtils.generateAnonymousScopedName(this.getScope(), this.schema);
            Long size = new Long(node.toString());
            if (result.getSchemaType() == null) {
                result.setSchemaType((XmlSchemaType)this.generateSchemaArray(scopedName, size, stype, this.getFullyQualifiedName()));
            } else {
                result.setSchemaType((XmlSchemaType)this.generateSchemaArray(scopedName, size, result.getSchemaType(), this.getFullyQualifiedName()));
            }
            if (result.getCorbaType() == null) {
                result.setCorbaType(this.generateCorbaAnonarray(scopedName.toString(), size, ctype, result.getSchemaType(), this.getFullyQualifiedName()));
            } else {
                result.setCorbaType(this.generateCorbaAnonarray(scopedName.toString(), size, result.getCorbaType(), result.getSchemaType(), this.getFullyQualifiedName()));
            }
            this.schema.getItems().add((XmlSchemaObject)result.getSchemaType());
            this.schema.addType(result.getSchemaType());
            this.typeMap.getStructOrExceptionOrUnion().add(result.getCorbaType());
        }
        return result;
    }

    private XmlSchemaComplexType generateSchemaArray(Scope scopedName, Long size, XmlSchemaType type, Scope fQName) {
        XmlSchemaComplexType complexType = new XmlSchemaComplexType(this.schema);
        complexType.setName(this.mapper.mapToQName(scopedName));
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        XmlSchemaElement element = new XmlSchemaElement();
        element.setMinOccurs(size.longValue());
        element.setMaxOccurs(size.longValue());
        element.setName(ELEMENT_NAME);
        if (type != null) {
            element.setSchemaTypeName(type.getQName());
            if (type.getQName().equals(ReferenceConstants.WSADDRESSING_TYPE)) {
                element.setNillable(true);
            }
        } else {
            ArrayDeferredAction arrayAction = new ArrayDeferredAction(element);
            this.wsdlVisitor.getDeferredActions().add(fQName, arrayAction);
        }
        sequence.getItems().add((XmlSchemaObject)element);
        complexType.setParticle((XmlSchemaParticle)sequence);
        return complexType;
    }

    private Array generateCorbaArray(Scope scopedName, Long size, CorbaTypeImpl type, XmlSchemaType stype, Scope fQName) {
        Array array = new Array();
        array.setQName(new QName(this.typeMap.getTargetNamespace(), scopedName.toString()));
        array.setBound(size);
        array.setRepositoryID(scopedName.toIDLRepositoryID());
        array.setType(stype.getQName());
        array.setElemname(new QName("", ELEMENT_NAME));
        if (type != null) {
            array.setElemtype(type.getQName());
        } else {
            ArrayDeferredAction arrayAction = new ArrayDeferredAction(array);
            this.wsdlVisitor.getDeferredActions().add(fQName, arrayAction);
        }
        return array;
    }

    private Anonarray generateCorbaAnonarray(String name, Long size, CorbaTypeImpl type, XmlSchemaType stype, Scope fQName) {
        Anonarray anonarray = new Anonarray();
        anonarray.setQName(new QName(this.typeMap.getTargetNamespace(), name));
        anonarray.setBound(size);
        anonarray.setType(stype.getQName());
        anonarray.setElemname(new QName("", ELEMENT_NAME));
        if (type != null) {
            anonarray.setElemtype(type.getQName());
        } else {
            ArrayDeferredAction anonarrayAction = new ArrayDeferredAction(anonarray);
            this.wsdlVisitor.getDeferredActions().add(fQName, anonarrayAction);
        }
        return anonarray;
    }

    class Types {
        private XmlSchemaType schemaType;
        private CorbaTypeImpl corbaType;
        private Scope fullyQualifiedName;

        public Types() {
            this.schemaType = null;
            this.corbaType = null;
        }

        public Types(XmlSchemaType stype, CorbaTypeImpl ctype, Scope fqName) {
            this.schemaType = stype;
            this.corbaType = ctype;
            this.fullyQualifiedName = fqName;
        }

        public void setSchemaType(XmlSchemaType stype) {
            this.schemaType = stype;
        }

        public void setCorbaType(CorbaTypeImpl ctype) {
            this.corbaType = ctype;
        }

        public XmlSchemaType getSchemaType() {
            return this.schemaType;
        }

        public CorbaTypeImpl getCorbaType() {
            return this.corbaType;
        }

        public void setFullyQualifiedName(Scope fqName) {
            this.fullyQualifiedName = fqName;
        }

        public Scope getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }
    }
}

