/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewCookieHeaderProvider
implements RuntimeDelegate.HeaderDelegate<NewCookie> {
    private static final String VERSION = "Version";
    private static final String PATH = "Path";
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String COMMENT = "Comment";
    private static final String SECURE = "Secure";

    public NewCookie fromString(String c) {
        String[] tokens;
        String name = null;
        String value = null;
        String path = null;
        String domain = null;
        String comment = null;
        int maxAge = -1;
        boolean isSecure = false;
        for (String token : tokens = c.split(";")) {
            if (token.startsWith(VERSION)) continue;
            if (token.startsWith(MAX_AGE)) {
                maxAge = Integer.parseInt(token.substring(MAX_AGE.length() + 1));
                continue;
            }
            if (token.startsWith(PATH)) {
                path = token.substring(PATH.length() + 1);
                continue;
            }
            if (token.startsWith(DOMAIN)) {
                domain = token.substring(DOMAIN.length() + 1);
                continue;
            }
            if (token.startsWith(COMMENT)) {
                comment = token.substring(COMMENT.length() + 1);
                continue;
            }
            if (token.startsWith(SECURE)) {
                isSecure = true;
                continue;
            }
            int i = token.indexOf(61);
            if (i == -1) continue;
            name = token.substring(0, i);
            value = i == token.length() + 1 ? "" : token.substring(i + 1);
        }
        if (name == null || value == null) {
            throw new IllegalArgumentException("Set-Cookie is malformed : " + c);
        }
        return new NewCookie(name, value, path, domain, comment, maxAge, isSecure);
    }

    public String toString(NewCookie value) {
        StringBuilder sb = new StringBuilder();
        sb.append(value.getName()).append('=').append(value.getValue());
        if (value.getComment() != null) {
            sb.append(';').append(COMMENT).append('=').append(value.getComment());
        }
        if (value.getDomain() != null) {
            sb.append(';').append(DOMAIN).append('=').append(value.getDomain());
        }
        if (value.getMaxAge() != -1) {
            sb.append(';').append(MAX_AGE).append('=').append(value.getMaxAge());
        }
        if (value.getPath() != null) {
            sb.append(';').append(PATH).append('=').append(value.getPath());
        }
        if (value.isSecure()) {
            sb.append(';').append(SECURE);
        }
        sb.append(';').append(VERSION).append('=').append(1);
        return sb.toString();
    }
}

