/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.springframework.beans.factory.xml.DefaultDocumentLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

class TunedDocumentLoader
extends DefaultDocumentLoader {
    private static DocumentBuilder documentBuilder;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private SAXParserFactory saxParserFactory;
    private SAXParserFactory nsasaxParserFactory;

    TunedDocumentLoader() {
        try {
            Class<?> cls = Class.forName("com.ctc.wstx.sax.WstxSAXParserFactory");
            this.saxParserFactory = (SAXParserFactory)cls.newInstance();
            this.nsasaxParserFactory = (SAXParserFactory)cls.newInstance();
        }
        catch (Exception e) {
            this.saxParserFactory = SAXParserFactory.newInstance();
            this.nsasaxParserFactory = SAXParserFactory.newInstance();
        }
        try {
            this.nsasaxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document loadDocument(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, int validationMode, boolean namespaceAware) throws Exception {
        if (validationMode == 0) {
            Document document;
            SAXParserFactory parserFactory = namespaceAware ? this.nsasaxParserFactory : this.saxParserFactory;
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(entityResolver);
            reader.setErrorHandler(errorHandler);
            SAXSource saxSource = new SAXSource(reader, inputSource);
            DocumentBuilder documentBuilder = TunedDocumentLoader.documentBuilder;
            synchronized (documentBuilder) {
                document = TunedDocumentLoader.documentBuilder.newDocument();
            }
            DOMResult domResult = new DOMResult((Node)document, inputSource.getSystemId());
            this.transformerFactory.newTransformer().transform(saxSource, domResult);
            return document;
        }
        return super.loadDocument(inputSource, entityResolver, errorHandler, validationMode, namespaceAware);
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory(int validationMode, boolean namespaceAware) throws ParserConfigurationException {
        DocumentBuilderFactory factory = super.createDocumentBuilderFactory(validationMode, namespaceAware);
        try {
            factory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (ParserConfigurationException pce) {
            // empty catch block
        }
        return factory;
    }

    static {
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

