/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyEngine;

public class PolicyVerificationInInterceptor
extends AbstractPolicyInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyVerificationInInterceptor.class);

    public PolicyVerificationInInterceptor() {
        super("pre-invoke");
    }

    protected void handle(Message message) {
        Exchange exchange = message.getExchange();
        assert (null != exchange);
        BindingOperationInfo boi = exchange.get(BindingOperationInfo.class);
        if (null == boi) {
            LOG.fine("No binding operation info.");
            return;
        }
        Endpoint e = exchange.get(Endpoint.class);
        if (null == e) {
            LOG.fine("No endpoint.");
            return;
        }
        EndpointInfo ei = e.getEndpointInfo();
        PolicyEngine pe = this.bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        AssertionInfoMap aim = message.get(AssertionInfoMap.class);
        if (null == aim) {
            return;
        }
        if (MessageUtils.isPartialResponse(message)) {
            LOG.fine("Not verifying policies on inbound partial response.");
            return;
        }
        this.getTransportAssertions(message);
        EffectivePolicy effectivePolicy = null;
        effectivePolicy = MessageUtils.isRequestor(message) ? pe.getEffectiveClientResponsePolicy(ei, boi) : pe.getEffectiveServerRequestPolicy(ei, boi);
        aim.checkEffectivePolicy(effectivePolicy.getPolicy());
        LOG.fine("Verified policies for inbound message.");
    }
}

