/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wstx_msv_validation;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.io.StaxValidationManager;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wstx_msv_validation.Stax2ValidationUtils;

@NoJSR250Annotations
public class WoodstoxValidationImpl
implements StaxValidationManager {
    private static final Logger LOG = LogUtils.getL7dLogger(WoodstoxValidationImpl.class);
    private Bus bus;
    private Stax2ValidationUtils utils;

    public WoodstoxValidationImpl(Bus b) {
        this.bus = b;
        try {
            this.utils = new Stax2ValidationUtils();
        }
        catch (Throwable e) {
            LOG.log(Level.FINE, "Problem initializing MSV validation", e);
            return;
        }
        if (null != this.bus) {
            this.bus.setExtension(this, StaxValidationManager.class);
        }
    }

    @Override
    public boolean setupValidation(XMLStreamReader reader, Endpoint endpoint, ServiceInfo serviceInfo) throws XMLStreamException {
        if (this.utils != null && reader != null) {
            return this.utils.setupValidation(reader, endpoint, serviceInfo);
        }
        return false;
    }

    @Override
    public boolean setupValidation(XMLStreamWriter writer, Endpoint endpoint, ServiceInfo serviceInfo) throws XMLStreamException {
        if (this.utils != null && writer != null) {
            return this.utils.setupValidation(writer, endpoint, serviceInfo);
        }
        return false;
    }
}

