/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.statistics.distribution.DistributionException;

public interface ContinuousDistribution {
    public double density(double var1);

    default public double probability(double x0, double x1) {
        if (x0 > x1) {
            throw new DistributionException("Lower bound %s > upper bound %s", x0, x1);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    default public double logDensity(double x) {
        return Math.log(this.density(x));
    }

    public double cumulativeProbability(double var1);

    default public double survivalProbability(double x) {
        return 1.0 - this.cumulativeProbability(x);
    }

    public double inverseCumulativeProbability(double var1);

    default public double inverseSurvivalProbability(double p) {
        return this.inverseCumulativeProbability(1.0 - p);
    }

    public double getMean();

    public double getVariance();

    public double getSupportLowerBound();

    public double getSupportUpperBound();

    public Sampler createSampler(UniformRandomProvider var1);

    public static interface Sampler {
        public double sample();
    }
}

