/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.RegularizedBeta;
import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.ArgumentUtils;
import org.apache.commons.statistics.distribution.DistributionException;
import org.apache.commons.statistics.distribution.SaddlePointExpansionUtils;

public final class BinomialDistribution
extends AbstractDiscreteDistribution {
    private static final float HALF = 0.5f;
    private final int numberOfTrials;
    private final double probabilityOfSuccess;
    private final double pmf0;
    private final double pmfn;

    private BinomialDistribution(int trials, double p) {
        this.probabilityOfSuccess = p;
        this.numberOfTrials = trials;
        this.pmf0 = this.probabilityOfSuccess >= 0.5 ? Math.pow(1.0 - this.probabilityOfSuccess, this.numberOfTrials) : Math.exp((double)this.numberOfTrials * Math.log1p(-this.probabilityOfSuccess));
        this.pmfn = Math.pow(this.probabilityOfSuccess, this.numberOfTrials);
    }

    public static BinomialDistribution of(int trials, double p) {
        if (trials < 0) {
            throw new DistributionException("Number %s is negative", trials);
        }
        ArgumentUtils.checkProbability(p);
        return new BinomialDistribution(trials, Math.abs(p));
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        if (x < 0 || x > this.numberOfTrials) {
            return 0.0;
        }
        if (x == 0) {
            return this.pmf0;
        }
        if (x == this.numberOfTrials) {
            return this.pmfn;
        }
        return Math.exp(SaddlePointExpansionUtils.logBinomialProbability(x, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess));
    }

    @Override
    public double logProbability(int x) {
        if (this.numberOfTrials == 0) {
            return x == 0 ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        if (x < 0 || x > this.numberOfTrials) {
            return Double.NEGATIVE_INFINITY;
        }
        return SaddlePointExpansionUtils.logBinomialProbability(x, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess);
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < 0) {
            return 0.0;
        }
        if (x >= this.numberOfTrials) {
            return 1.0;
        }
        if (x == 0) {
            return this.pmf0;
        }
        return RegularizedBeta.complement((double)this.probabilityOfSuccess, (double)((double)x + 1.0), (double)((double)this.numberOfTrials - (double)x));
    }

    @Override
    public double survivalProbability(int x) {
        if (x < 0) {
            return 1.0;
        }
        if (x >= this.numberOfTrials) {
            return 0.0;
        }
        if (x == this.numberOfTrials - 1) {
            return this.pmfn;
        }
        return RegularizedBeta.value((double)this.probabilityOfSuccess, (double)((double)x + 1.0), (double)((double)this.numberOfTrials - (double)x));
    }

    @Override
    public double getMean() {
        return (double)this.numberOfTrials * this.probabilityOfSuccess;
    }

    @Override
    public double getVariance() {
        double p = this.probabilityOfSuccess;
        return (double)this.numberOfTrials * p * (1.0 - p);
    }

    @Override
    public int getSupportLowerBound() {
        return this.probabilityOfSuccess < 1.0 ? 0 : this.numberOfTrials;
    }

    @Override
    public int getSupportUpperBound() {
        return this.probabilityOfSuccess > 0.0 ? this.numberOfTrials : 0;
    }

    @Override
    protected int getMedian() {
        return (int)((double)this.numberOfTrials * this.probabilityOfSuccess);
    }
}

