/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.shape;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratSampler;

public abstract class UnitBallSampler
implements SharedStateObjectSampler<double[]> {
    private static final int ONE_D = 1;
    private static final int TWO_D = 2;
    private static final int THREE_D = 3;
    private static final double DOUBLE_MULTIPLIER = (double)1.110223E-16f;

    @Override
    public abstract double[] sample();

    @Override
    public abstract UnitBallSampler withUniformRandomProvider(UniformRandomProvider var1);

    public static UnitBallSampler of(UniformRandomProvider rng, int dimension) {
        if (dimension <= 0) {
            throw new IllegalArgumentException("Dimension must be strictly positive");
        }
        if (dimension == 1) {
            return new UnitBallSampler1D(rng);
        }
        if (dimension == 2) {
            return new UnitBallSampler2D(rng);
        }
        if (dimension == 3) {
            return new UnitBallSampler3D(rng);
        }
        return new UnitBallSamplerND(rng, dimension);
    }

    private static double makeSignedDouble(long bits) {
        return (double)(bits >> 10) * (double)1.110223E-16f;
    }

    private static class UnitBallSamplerND
    extends UnitBallSampler {
        private final int dimension;
        private final NormalizedGaussianSampler normal;
        private final ContinuousSampler exp;

        UnitBallSamplerND(UniformRandomProvider rng, int dimension) {
            this.dimension = dimension;
            this.normal = ZigguratSampler.NormalizedGaussian.of(rng);
            this.exp = ZigguratSampler.Exponential.of(rng);
        }

        @Override
        public double[] sample() {
            double[] sample = new double[this.dimension];
            double sum = this.exp.sample() * 2.0;
            for (int i = 0; i < this.dimension; ++i) {
                double x = this.normal.sample();
                sum += x * x;
                sample[i] = x;
            }
            if (sum == 0.0) {
                return this.sample();
            }
            double f = 1.0 / Math.sqrt(sum);
            int i = 0;
            while (i < this.dimension) {
                int n = i++;
                sample[n] = sample[n] * f;
            }
            return sample;
        }

        @Override
        public UnitBallSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new UnitBallSamplerND(rng, this.dimension);
        }
    }

    private static class UnitBallSampler3D
    extends UnitBallSampler {
        private final NormalizedGaussianSampler normal;
        private final ContinuousSampler exp;

        UnitBallSampler3D(UniformRandomProvider rng) {
            this.normal = ZigguratSampler.NormalizedGaussian.of(rng);
            this.exp = ZigguratSampler.Exponential.of(rng);
        }

        @Override
        public double[] sample() {
            double x = this.normal.sample();
            double y = this.normal.sample();
            double z = this.normal.sample();
            double sum = this.exp.sample() * 2.0 + x * x + y * y + z * z;
            if (sum == 0.0) {
                return this.sample();
            }
            double f = 1.0 / Math.sqrt(sum);
            return new double[]{x * f, y * f, z * f};
        }

        @Override
        public UnitBallSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new UnitBallSampler3D(rng);
        }
    }

    private static class UnitBallSampler2D
    extends UnitBallSampler {
        private final UniformRandomProvider rng;

        UnitBallSampler2D(UniformRandomProvider rng) {
            this.rng = rng;
        }

        @Override
        public double[] sample() {
            double y;
            double x;
            while ((x = UnitBallSampler.makeSignedDouble(this.rng.nextLong())) * x + (y = UnitBallSampler.makeSignedDouble(this.rng.nextLong())) * y > 1.0) {
            }
            return new double[]{x, y};
        }

        @Override
        public UnitBallSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new UnitBallSampler2D(rng);
        }
    }

    private static class UnitBallSampler1D
    extends UnitBallSampler {
        private final UniformRandomProvider rng;

        UnitBallSampler1D(UniformRandomProvider rng) {
            this.rng = rng;
        }

        @Override
        public double[] sample() {
            return new double[]{UnitBallSampler.makeSignedDouble(this.rng.nextLong())};
        }

        @Override
        public UnitBallSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new UnitBallSampler1D(rng);
        }
    }
}

