/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.shape;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;
import org.apache.commons.rng.sampling.shape.Coordinates;

public abstract class LineSampler
implements SharedStateObjectSampler<double[]> {
    private static final int ONE_D = 1;
    private static final int TWO_D = 2;
    private static final int THREE_D = 3;
    private final UniformRandomProvider rng;

    LineSampler(UniformRandomProvider rng) {
        this.rng = rng;
    }

    @Override
    public double[] sample() {
        double u = this.rng.nextDouble();
        return this.createSample(1.0 - u, u);
    }

    protected abstract double[] createSample(double var1, double var3);

    @Override
    public abstract LineSampler withUniformRandomProvider(UniformRandomProvider var1);

    public static LineSampler of(UniformRandomProvider rng, double[] a, double[] b) {
        int dimension = a.length;
        if (dimension != b.length) {
            throw new IllegalArgumentException("Mismatch of vertex dimensions: " + dimension + ',' + b.length);
        }
        Coordinates.requireFinite(a, "Vertex a");
        Coordinates.requireFinite(b, "Vertex b");
        if (dimension == 2) {
            return new LineSampler2D(rng, a, b);
        }
        if (dimension == 3) {
            return new LineSampler3D(rng, a, b);
        }
        if (dimension > 3) {
            return new LineSamplerND(rng, a, b);
        }
        if (dimension == 1) {
            return new LineSampler1D(rng, a, b);
        }
        throw new IllegalArgumentException("Unsupported dimension: " + dimension);
    }

    private static class LineSamplerND
    extends LineSampler {
        private final double[] a;
        private final double[] b;

        LineSamplerND(UniformRandomProvider rng, double[] a, double[] b) {
            super(rng);
            this.a = (double[])a.clone();
            this.b = (double[])b.clone();
        }

        LineSamplerND(UniformRandomProvider rng, LineSamplerND source) {
            super(rng);
            this.a = source.a;
            this.b = source.b;
        }

        @Override
        public double[] createSample(double p1mu, double u) {
            double[] x = new double[this.a.length];
            for (int i = 0; i < x.length; ++i) {
                x[i] = p1mu * this.a[i] + u * this.b[i];
            }
            return x;
        }

        @Override
        public LineSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new LineSamplerND(rng, this);
        }
    }

    private static class LineSampler3D
    extends LineSampler {
        private final double ax;
        private final double ay;
        private final double az;
        private final double bx;
        private final double by;
        private final double bz;

        LineSampler3D(UniformRandomProvider rng, double[] a, double[] b) {
            super(rng);
            this.ax = a[0];
            this.ay = a[1];
            this.az = a[2];
            this.bx = b[0];
            this.by = b[1];
            this.bz = b[2];
        }

        LineSampler3D(UniformRandomProvider rng, LineSampler3D source) {
            super(rng);
            this.ax = source.ax;
            this.ay = source.ay;
            this.az = source.az;
            this.bx = source.bx;
            this.by = source.by;
            this.bz = source.bz;
        }

        @Override
        public double[] createSample(double p1mu, double u) {
            return new double[]{p1mu * this.ax + u * this.bx, p1mu * this.ay + u * this.by, p1mu * this.az + u * this.bz};
        }

        @Override
        public LineSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new LineSampler3D(rng, this);
        }
    }

    private static class LineSampler2D
    extends LineSampler {
        private final double ax;
        private final double ay;
        private final double bx;
        private final double by;

        LineSampler2D(UniformRandomProvider rng, double[] a, double[] b) {
            super(rng);
            this.ax = a[0];
            this.ay = a[1];
            this.bx = b[0];
            this.by = b[1];
        }

        LineSampler2D(UniformRandomProvider rng, LineSampler2D source) {
            super(rng);
            this.ax = source.ax;
            this.ay = source.ay;
            this.bx = source.bx;
            this.by = source.by;
        }

        @Override
        public double[] createSample(double p1mu, double u) {
            return new double[]{p1mu * this.ax + u * this.bx, p1mu * this.ay + u * this.by};
        }

        @Override
        public LineSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new LineSampler2D(rng, this);
        }
    }

    private static class LineSampler1D
    extends LineSampler {
        private final double ax;
        private final double bx;

        LineSampler1D(UniformRandomProvider rng, double[] a, double[] b) {
            super(rng);
            this.ax = a[0];
            this.bx = b[0];
        }

        LineSampler1D(UniformRandomProvider rng, LineSampler1D source) {
            super(rng);
            this.ax = source.ax;
            this.bx = source.bx;
        }

        @Override
        public double[] createSample(double p1mu, double u) {
            return new double[]{p1mu * this.ax + u * this.bx};
        }

        @Override
        public LineSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new LineSampler1D(rng, this);
        }
    }
}

