/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;

public class LogNormalSampler
implements SharedStateContinuousSampler {
    private final double scale;
    private final double shape;
    private final NormalizedGaussianSampler gaussian;

    public LogNormalSampler(NormalizedGaussianSampler gaussian, double scale, double shape) {
        if (scale < 0.0) {
            throw new IllegalArgumentException("scale is not positive: " + scale);
        }
        if (shape <= 0.0) {
            throw new IllegalArgumentException("shape is not strictly positive: " + shape);
        }
        this.scale = scale;
        this.shape = shape;
        this.gaussian = gaussian;
    }

    private LogNormalSampler(UniformRandomProvider rng, LogNormalSampler source) {
        this.scale = source.scale;
        this.shape = source.shape;
        this.gaussian = InternalUtils.newNormalizedGaussianSampler(source.gaussian, rng);
    }

    @Override
    public double sample() {
        return Math.exp(this.scale + this.shape * this.gaussian.sample());
    }

    public String toString() {
        return "Log-normal deviate [" + this.gaussian.toString() + "]";
    }

    @Override
    public SharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return new LogNormalSampler(rng, this);
    }

    public static SharedStateContinuousSampler of(NormalizedGaussianSampler gaussian, double scale, double shape) {
        return new LogNormalSampler(gaussian, scale, shape);
    }
}

