/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;

public class SmallMeanPoissonSampler
implements DiscreteSampler {
    private static final double MAX_MEAN = 1.0737418235E9;
    private final double p0;
    private final int limit;
    private final UniformRandomProvider rng;

    public SmallMeanPoissonSampler(UniformRandomProvider rng, double mean) {
        this.rng = rng;
        if (mean <= 0.0) {
            throw new IllegalArgumentException(mean + " <= " + 0);
        }
        if (mean > 1.0737418235E9) {
            throw new IllegalArgumentException(mean + " > " + 1.0737418235E9);
        }
        this.p0 = Math.exp(-mean);
        this.limit = (int)Math.ceil(Math.min(1000.0 * mean, 2.147483647E9));
    }

    @Override
    public int sample() {
        int n;
        double r = 1.0;
        for (n = 0; n < this.limit && (r *= this.rng.nextDouble()) >= this.p0; ++n) {
        }
        return n;
    }

    public String toString() {
        return "Small Mean Poisson deviate [" + this.rng.toString() + "]";
    }
}

