/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class AhrensDieterExponentialSampler
extends SamplerBase
implements ContinuousSampler {
    private static final double[] EXPONENTIAL_SA_QI = new double[16];
    private final double mean;
    private final UniformRandomProvider rng;

    public AhrensDieterExponentialSampler(UniformRandomProvider rng, double mean) {
        super(null);
        this.rng = rng;
        this.mean = mean;
    }

    @Override
    public double sample() {
        double u2;
        double u;
        double a = 0.0;
        for (u = this.rng.nextDouble(); u < 0.5; u *= 2.0) {
            a += EXPONENTIAL_SA_QI[0];
        }
        if ((u += u - 1.0) <= EXPONENTIAL_SA_QI[0]) {
            return this.mean * (a + u);
        }
        int i = 0;
        double umin = u2 = this.rng.nextDouble();
        do {
            ++i;
            u2 = this.rng.nextDouble();
            if (!(u2 < umin)) continue;
            umin = u2;
        } while (u > EXPONENTIAL_SA_QI[i]);
        return this.mean * (a + umin * EXPONENTIAL_SA_QI[0]);
    }

    @Override
    public String toString() {
        return "Ahrens-Dieter Exponential deviate [" + this.rng.toString() + "]";
    }

    static {
        double ln2 = Math.log(2.0);
        double qi = 0.0;
        for (int i = 0; i < EXPONENTIAL_SA_QI.length; ++i) {
            AhrensDieterExponentialSampler.EXPONENTIAL_SA_QI[i] = qi += Math.pow(ln2, i + 1) / (double)InternalUtils.factorial(i + 1);
        }
    }
}

