/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.rng.UniformRandomProvider;

public class DiscreteProbabilityCollectionSampler<T> {
    private final List<T> items;
    private final UniformRandomProvider rng;
    private final double[] cumulativeProbabilities;

    public DiscreteProbabilityCollectionSampler(UniformRandomProvider rng, Map<T, Double> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Empty collection");
        }
        this.rng = rng;
        int size = collection.size();
        this.items = new ArrayList<T>(size);
        this.cumulativeProbabilities = new double[size];
        double sumProb = 0.0;
        int count = 0;
        for (Map.Entry<T, Double> e : collection.entrySet()) {
            this.items.add(e.getKey());
            double prob = e.getValue();
            if (prob < 0.0 || Double.isInfinite(prob) || Double.isNaN(prob)) {
                throw new IllegalArgumentException("Invalid probability: " + prob);
            }
            this.cumulativeProbabilities[count++] = prob;
            sumProb += prob;
        }
        if (!(sumProb > 0.0)) {
            throw new IllegalArgumentException("Invalid sum of probabilities");
        }
        for (int i = 0; i < size; ++i) {
            int n = i;
            this.cumulativeProbabilities[n] = this.cumulativeProbabilities[n] / sumProb;
            if (i <= 0) continue;
            int n2 = i;
            this.cumulativeProbabilities[n2] = this.cumulativeProbabilities[n2] + this.cumulativeProbabilities[i - 1];
        }
    }

    public DiscreteProbabilityCollectionSampler(UniformRandomProvider rng, List<T> collection, double[] probabilities) {
        this(rng, DiscreteProbabilityCollectionSampler.consolidate(collection, probabilities));
    }

    public T sample() {
        double rand = this.rng.nextDouble();
        int index = Arrays.binarySearch(this.cumulativeProbabilities, rand);
        if (index < 0) {
            index = -index - 1;
        }
        if (index >= 0 && index < this.cumulativeProbabilities.length && rand < this.cumulativeProbabilities[index]) {
            return this.items.get(index);
        }
        return this.items.get(this.items.size() - 1);
    }

    private static <T> Map<T, Double> consolidate(List<T> collection, double[] probabilities) {
        int len = probabilities.length;
        if (len != collection.size()) {
            throw new IllegalArgumentException("Size mismatch: " + len + " != " + collection.size());
        }
        HashMap<T, Double> map = new HashMap<T, Double>();
        for (int i = 0; i < len; ++i) {
            T item = collection.get(i);
            Double prob = probabilities[i];
            Double currentProb = (Double)map.get(item);
            if (currentProb == null) {
                currentProb = 0.0;
            }
            map.put(item, currentProb + prob);
        }
        return map;
    }
}

