/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.sampling.distribution.InternalGamma;

class InternalUtils {
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    private InternalUtils() {
    }

    public static long factorial(int n) {
        return FACTORIALS[n];
    }

    public static final class FactorialLog {
        private final double[] LOG_FACTORIALS;

        private FactorialLog(int numValues, double[] cache) {
            int i;
            this.LOG_FACTORIALS = new double[numValues];
            int beginCopy = 2;
            int endCopy = cache == null || cache.length <= 2 ? 2 : (cache.length <= numValues ? cache.length : numValues);
            for (i = 2; i < endCopy; ++i) {
                this.LOG_FACTORIALS[i] = cache[i];
            }
            for (i = endCopy; i < numValues; ++i) {
                this.LOG_FACTORIALS[i] = this.LOG_FACTORIALS[i - 1] + Math.log(i);
            }
        }

        public static FactorialLog create() {
            return new FactorialLog(0, null);
        }

        public FactorialLog withCache(int cacheSize) {
            return new FactorialLog(cacheSize, this.LOG_FACTORIALS);
        }

        public double value(int n) {
            if (n < this.LOG_FACTORIALS.length) {
                return this.LOG_FACTORIALS[n];
            }
            if (n < FACTORIALS.length) {
                return Math.log(FACTORIALS[n]);
            }
            return InternalGamma.logGamma(n + 1);
        }
    }
}

