/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class UnitSphereSampler {
    private final NormalizedGaussianSampler sampler;
    private final int dimension;

    public UnitSphereSampler(int dimension, UniformRandomProvider rng) {
        this.dimension = dimension;
        this.sampler = new ZigguratNormalizedGaussianSampler(rng);
    }

    public double[] nextVector() {
        double[] v = new double[this.dimension];
        double normSq = 0.0;
        for (int i = 0; i < this.dimension; ++i) {
            double comp;
            v[i] = comp = this.sampler.sample();
            normSq += comp * comp;
        }
        double f = 1.0 / Math.sqrt(normSq);
        int i = 0;
        while (i < this.dimension) {
            int n = i++;
            v[n] = v[n] * f;
        }
        return v;
    }
}

