/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class ContinuousUniformSampler
extends SamplerBase
implements ContinuousSampler {
    private final double lo;
    private final double hi;

    public ContinuousUniformSampler(UniformRandomProvider rng, double lo, double hi) {
        super(rng);
        this.lo = lo;
        this.hi = hi;
    }

    @Override
    public double sample() {
        double u = this.nextDouble();
        return u * this.hi + (1.0 - u) * this.lo;
    }

    @Override
    public String toString() {
        return "Uniform deviate [" + super.toString() + "]";
    }
}

