/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.rng.UniformRandomProvider;

public class RandomStressTester {
    private static final String C = "# ";
    private static final String N = "\n";
    private final List<String> cmdLine;
    private final String fileOutputPrefix;

    private RandomStressTester(List<String> cmd, String outputPrefix) {
        File exec = new File(cmd.get(0));
        if (!exec.exists() || !exec.canExecute()) {
            throw new RuntimeException("Program is not executable: " + exec);
        }
        this.cmdLine = new ArrayList<String>(cmd);
        this.fileOutputPrefix = outputPrefix;
        File reportDir = new File(this.fileOutputPrefix).getParentFile();
        if (!(reportDir.exists() && reportDir.isDirectory() && reportDir.canWrite())) {
            throw new RuntimeException("Invalid output directory: " + reportDir);
        }
    }

    public static void main(String[] args) {
        String output = args[0];
        int numThreads = Integer.valueOf(args[1]);
        Iterable<UniformRandomProvider> rngList = RandomStressTester.createGeneratorsList(args[2]);
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.addAll(Arrays.asList(Arrays.copyOfRange(args, 3, args.length)));
        RandomStressTester app = new RandomStressTester(cmdLine, output);
        try {
            app.run(rngList, numThreads);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void run(Iterable<UniformRandomProvider> generators, int numConcurrentTasks) throws IOException {
        ExecutorService service = Executors.newFixedThreadPool(numConcurrentTasks);
        ArrayList execOutput = new ArrayList();
        int count = 0;
        for (UniformRandomProvider uniformRandomProvider : generators) {
            File output = new File(this.fileOutputPrefix + ++count);
            Task r = new Task(uniformRandomProvider, output);
            execOutput.add(service.submit(r));
        }
        try {
            for (Future future : execOutput) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    System.err.println(e.getCause().getMessage());
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        service.shutdown();
    }

    private static Iterable<UniformRandomProvider> createGeneratorsList(String name) {
        try {
            return (Iterable)Class.forName(name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private void printHeader(File output, UniformRandomProvider rng) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(C).append(N);
        sb.append(C).append("RNG: ").append(rng.toString()).append(N);
        sb.append(C).append(N);
        sb.append(C).append("Java: ").append(System.getProperty("java.version")).append(N);
        sb.append(C).append("Runtime: ").append(System.getProperty("java.runtime.version", "?")).append(N);
        sb.append(C).append("JVM: ").append(System.getProperty("java.vm.name")).append(" ").append(System.getProperty("java.vm.version")).append(N);
        sb.append(C).append("OS: ").append(System.getProperty("os.name")).append(" ").append(System.getProperty("os.version")).append(" ").append(System.getProperty("os.arch")).append(N);
        sb.append(C).append(N);
        sb.append(C).append("Analyzer: ");
        for (String s : this.cmdLine) {
            sb.append(s).append(" ");
        }
        sb.append(N);
        sb.append(C).append(N);
        PrintWriter w = new PrintWriter(new FileWriter(output, true));
        w.print(sb.toString());
        w.close();
    }

    private void printFooter(File output, long nanoTime) throws IOException {
        PrintWriter w = new PrintWriter(new FileWriter(output, true));
        w.println(C);
        double duration = (double)nanoTime * 1.0E-9 / 60.0;
        w.println("# Test duration: " + duration + " minutes");
        w.println(C);
        w.close();
    }

    private class Task
    implements Runnable {
        private final File output;
        private final UniformRandomProvider rng;

        Task(UniformRandomProvider random, File report) {
            this.rng = random;
            this.output = report;
        }

        @Override
        public void run() {
            try {
                RandomStressTester.this.printHeader(this.output, this.rng);
                ProcessBuilder builder = new ProcessBuilder(RandomStressTester.this.cmdLine);
                builder.redirectOutput(ProcessBuilder.Redirect.appendTo(this.output));
                Process testingProcess = builder.start();
                DataOutputStream sink = new DataOutputStream(testingProcess.getOutputStream());
                long startTime = System.nanoTime();
                try {
                    while (true) {
                        sink.writeInt(this.rng.nextInt());
                    }
                }
                catch (IOException iOException) {
                    long endTime = System.nanoTime();
                    RandomStressTester.this.printFooter(this.output, endTime - startTime);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to start task: " + e.getMessage());
            }
        }
    }
}

