/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.rng.core.source32.RandomIntSource;
import org.apache.commons.rng.core.source64.RandomLongSource;
import org.apache.commons.rng.examples.stress.ApplicationException;
import org.apache.commons.rng.examples.stress.StressTestData;
import org.apache.commons.rng.simple.RandomSource;
import org.apache.commons.rng.simple.internal.ProviderBuilder;

class StressTestDataList
implements Iterable<StressTestData> {
    private static final EnumMap<RandomSource, Object[]> EXAMPLE_ARGUMENTS = new EnumMap(RandomSource.class);
    private final List<StressTestData> list = new ArrayList<StressTestData>();

    private StressTestDataList() {
    }

    StressTestDataList(String idPrefix, int numberOfTrials) {
        for (RandomSource source : RandomSource.values()) {
            Object[] args = EXAMPLE_ARGUMENTS.get(source);
            StressTestData data = new StressTestData(source, args).withIDPrefix(idPrefix);
            if (args == null && numberOfTrials > 0) {
                data = data.withTrials(numberOfTrials);
            }
            this.list.add(data);
        }
    }

    @Override
    public Iterator<StressTestData> iterator() {
        return this.list.iterator();
    }

    public StressTestDataList subsetIntSource() {
        return this.subsetOf(RandomIntSource.class);
    }

    public StressTestDataList subsetLongSource() {
        return this.subsetOf(RandomLongSource.class);
    }

    private StressTestDataList subsetOf(Class<?> type) {
        StressTestDataList subset = new StressTestDataList();
        for (StressTestData data : this.list) {
            ProviderBuilder.RandomSourceInternal source;
            try {
                source = ProviderBuilder.RandomSourceInternal.valueOf((String)data.getRandomSource().name());
            }
            catch (IllegalArgumentException ex) {
                throw new ApplicationException("Unknown internal source: " + data.getRandomSource(), ex);
            }
            if (!type.isAssignableFrom(source.getRng())) continue;
            subset.list.add(data);
        }
        return subset;
    }

    static {
        EXAMPLE_ARGUMENTS.put(RandomSource.TWO_CMRES_SELECT, new Object[]{1, 2});
    }
}

