/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;

class StressTestData {
    private final String id;
    private final RandomSource randomSource;
    private final Object[] args;
    private final int trials;

    StressTestData(RandomSource randomSource, Object[] args) {
        this(Integer.toString(randomSource.ordinal() + 1), randomSource, args, args == null ? 1 : 0);
    }

    StressTestData(String id, RandomSource randomSource, Object[] args, int trials) {
        this.id = id;
        this.randomSource = randomSource;
        this.args = args;
        this.trials = trials;
    }

    StressTestData withIDPrefix(String idPrefix) {
        return new StressTestData(idPrefix + this.id, this.randomSource, this.args, this.trials);
    }

    StressTestData withTrials(int numberOfTrials) {
        return new StressTestData(this.id, this.randomSource, this.args, numberOfTrials);
    }

    UniformRandomProvider createRNG(byte[] seed) {
        return RandomSource.create((RandomSource)this.randomSource, (Object)seed, (Object[])this.args);
    }

    String getId() {
        return this.id;
    }

    RandomSource getRandomSource() {
        return this.randomSource;
    }

    Object[] getArgs() {
        return this.args;
    }

    int getTrials() {
        return this.trials;
    }
}

