/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

final class LogUtils {
    private static LogLevel logLevel = LogLevel.INFO;

    private LogUtils() {
    }

    static void setLogLevel(LogLevel logLevel) {
        LogUtils.logLevel = logLevel;
    }

    static boolean isLoggable(LogLevel level) {
        return level.getLevel() <= logLevel.getLevel();
    }

    static void debug(String message) {
        if (LogUtils.isLoggable(LogLevel.DEBUG)) {
            LogUtils.println(System.out, LogLevel.DEBUG.getPrefix() + message);
        }
    }

    static void debug(String format, Object ... args) {
        if (LogUtils.isLoggable(LogLevel.DEBUG)) {
            LogUtils.printf(System.out, LogLevel.DEBUG.getPrefix() + format, args);
        }
    }

    static void info(String message) {
        if (LogUtils.isLoggable(LogLevel.INFO)) {
            LogUtils.println(System.out, LogLevel.INFO.getPrefix() + message);
        }
    }

    static void info(String format, Object ... args) {
        if (LogUtils.isLoggable(LogLevel.INFO)) {
            LogUtils.printf(System.out, LogLevel.INFO.getPrefix() + format, args);
        }
    }

    static void error(String message) {
        if (LogUtils.isLoggable(LogLevel.ERROR)) {
            LogUtils.println(System.err, LogLevel.ERROR.getPrefix() + message);
        }
    }

    static void error(String format, Object ... args) {
        if (LogUtils.isLoggable(LogLevel.ERROR)) {
            LogUtils.printf(System.err, LogLevel.ERROR.getPrefix() + format, args);
        }
    }

    static void error(Throwable thrown, String message) {
        if (LogUtils.isLoggable(LogLevel.ERROR)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = LogUtils.createErrorPrintWriter(sw);
            pw.print(message);
            LogUtils.addStackTrace(pw, thrown);
            LogUtils.println(System.err, sw.toString());
        }
    }

    static void error(Throwable thrown, String format, Object ... args) {
        if (LogUtils.isLoggable(LogLevel.ERROR)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = LogUtils.createErrorPrintWriter(sw);
            pw.printf(format, args);
            LogUtils.addStackTrace(pw, thrown);
            LogUtils.printf(System.err, sw.toString(), new Object[0]);
        }
    }

    private static PrintWriter createErrorPrintWriter(StringWriter sw) {
        PrintWriter pw = new PrintWriter(sw);
        pw.print(LogLevel.ERROR.getPrefix());
        return pw;
    }

    private static void addStackTrace(PrintWriter pw, Throwable thrown) {
        pw.println();
        thrown.printStackTrace(pw);
    }

    private static void println(PrintStream out, String message) {
        out.println(message);
    }

    private static void printf(PrintStream out, String format, Object ... args) {
        out.printf(format + "%n", args);
    }

    static enum LogLevel {
        ERROR(0),
        INFO(1),
        DEBUG(2);

        private final String prefix = "[" + this.name() + "] ";
        private final int level;

        private LogLevel(int level) {
            this.level = level;
        }

        String getPrefix() {
            return this.prefix;
        }

        int getLevel() {
            return this.level;
        }
    }
}

