/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.sampling;

import java.util.concurrent.Callable;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.examples.sampling.StandardOptions;
import org.apache.commons.rng.sampling.distribution.BoxMullerNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.MarsagliaNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;
import org.apache.commons.rng.simple.RandomSource;
import picocli.CommandLine;

@CommandLine.Command(name="visual", description={"Show output from a tiny region of the sampler."})
class UniformSamplingVisualCheckCommand
implements Callable<Void> {
    @CommandLine.Mixin
    private StandardOptions reusableOptions;
    @CommandLine.Option(names={"-l", "--low"}, description={"The lower bound (default: ${DEFAULT-VALUE})."})
    private float lo = 0.1f;
    @CommandLine.Option(names={"-b", "--bands"}, description={"The number of bands for the range (default: ${DEFAULT-VALUE})."})
    private int bands = 2;
    @CommandLine.Option(names={"-s", "--samples"}, description={"The number of samples in the tiny range (default: ${DEFAULT-VALUE})."})
    private int numSamples = 50;
    private final UniformRandomProvider rng = RandomSource.create((RandomSource)RandomSource.XOR_SHIFT_1024_S_PHI);
    private final ContinuousSampler[] samplers = new ContinuousSampler[]{ZigguratNormalizedGaussianSampler.of((UniformRandomProvider)this.rng), MarsagliaNormalizedGaussianSampler.of((UniformRandomProvider)this.rng), BoxMullerNormalizedGaussianSampler.of((UniformRandomProvider)this.rng)};

    UniformSamplingVisualCheckCommand() {
    }

    @Override
    public Void call() {
        int i;
        float hi = this.lo;
        for (i = 0; i < this.bands; ++i) {
            hi = Math.nextUp(hi);
        }
        System.out.printf("# lower=%.16e%n", Float.valueOf(this.lo));
        System.out.printf("# upper=%.16e%n", Float.valueOf(hi));
        for (i = 0; i < this.samplers.length; ++i) {
            System.out.printf("# [%d] %s%n", i, this.samplers[i].getClass().getSimpleName());
        }
        for (int n = 0; n < this.numSamples; ++n) {
            System.out.printf("[%d]", n, this.rng.nextDouble());
            for (ContinuousSampler s : this.samplers) {
                double r = s.sample();
                while (r < (double)this.lo || r > (double)hi) {
                    r = s.sample();
                }
                System.out.printf("\t%.16e", r);
            }
            System.out.println();
        }
        return null;
    }
}

