/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.quadrature;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;

public abstract class MonteCarloIntegration {
    private final UniformRandomProvider rng;
    private final int dimension;

    public MonteCarloIntegration(RandomSource source, int dimension) {
        this.rng = RandomSource.create((RandomSource)source);
        this.dimension = dimension;
    }

    public double integrate(long n) {
        double result = 0.0;
        long inside = 0L;
        long total = 0L;
        while (total < n) {
            if (this.isInside(this.generateU01())) {
                ++inside;
            }
            result = (double)inside / (double)(++total);
        }
        return result;
    }

    protected abstract boolean isInside(double ... var1);

    private double[] generateU01() {
        double[] rand = new double[this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            rand[i] = this.rng.nextDouble();
        }
        return rand;
    }
}

