/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.quadrature;

import org.apache.commons.rng.examples.quadrature.MonteCarloIntegration;
import org.apache.commons.rng.simple.RandomSource;

public class ComputePi
extends MonteCarloIntegration {
    private static final int DIMENSION = 2;

    public ComputePi(RandomSource source) {
        super(source, 2);
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalStateException("Missing arguments");
        }
        long numPoints = Long.parseLong(args[0]);
        RandomSource randomSource = RandomSource.valueOf((String)args[1]);
        ComputePi piApp = new ComputePi(randomSource);
        double piMC = piApp.compute(numPoints);
        System.out.println("After generating " + 2L * numPoints + " random numbers, the error on \ud835\uded1 is " + Math.abs(piMC - Math.PI));
    }

    public double compute(long numPoints) {
        return 4.0 * this.integrate(numPoints);
    }

    @Override
    protected boolean isInside(double ... rand) {
        double r2 = rand[0] * rand[0] + rand[1] * rand[1];
        return r2 <= 1.0;
    }
}

