/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.simple;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class SeedArrayGenerationPerformance {
    private static final ReentrantLock UNFAIR_LOCK = new ReentrantLock(false);
    private static final ReentrantLock FAIR_LOCK = new ReentrantLock(true);
    private int[] intValue;
    private long[] longValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextInt(UniformRandomProvider rng) {
        UniformRandomProvider uniformRandomProvider = rng;
        synchronized (uniformRandomProvider) {
            return rng.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long nextLong(UniformRandomProvider rng) {
        UniformRandomProvider uniformRandomProvider = rng;
        synchronized (uniformRandomProvider) {
            return rng.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void nextInt(UniformRandomProvider rng, int[] array, int start, int end) {
        UniformRandomProvider uniformRandomProvider = rng;
        synchronized (uniformRandomProvider) {
            for (int i = start; i < end; ++i) {
                array[i] = rng.nextInt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void nextLong(UniformRandomProvider rng, long[] array, int start, int end) {
        UniformRandomProvider uniformRandomProvider = rng;
        synchronized (uniformRandomProvider) {
            for (int i = start; i < end; ++i) {
                array[i] = rng.nextLong();
            }
        }
    }

    private static int nextInt(Lock lock, UniformRandomProvider rng) {
        lock.lock();
        try {
            int n = rng.nextInt();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long nextLong(Lock lock, UniformRandomProvider rng) {
        lock.lock();
        try {
            long l = rng.nextLong();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void nextInt(Lock lock, UniformRandomProvider rng, int[] array, int start, int end) {
        lock.lock();
        try {
            for (int i = start; i < end; ++i) {
                array[i] = rng.nextInt();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void nextLong(Lock lock, UniformRandomProvider rng, long[] array, int start, int end) {
        lock.lock();
        try {
            for (int i = start; i < end; ++i) {
                array[i] = rng.nextLong();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Benchmark
    public void baselineVoid() {
    }

    @Benchmark
    public int[] baselineIntArray() {
        return this.intValue;
    }

    @Benchmark
    public long[] baselineLongArray() {
        return this.longValue;
    }

    @Benchmark
    public int[] createIntArraySeed(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = rng.nextInt();
        }
        return seed;
    }

    @Benchmark
    public long[] createLongArraySeed(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = rng.nextLong();
        }
        return seed;
    }

    @Benchmark
    public int[] Threads1_createIntArraySeed_Sync(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextInt(rng);
        }
        return seed;
    }

    @Benchmark
    public long[] Threads1_createLongArraySeed_Sync(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextLong(rng);
        }
        return seed;
    }

    @Benchmark
    public int[] Threads1_createIntArraySeed_UnfairLock(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextInt(UNFAIR_LOCK, rng);
        }
        return seed;
    }

    @Benchmark
    public long[] Threads1_createLongArraySeed_UnfairLock(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextLong(UNFAIR_LOCK, rng);
        }
        return seed;
    }

    @Benchmark
    public int[] Threads1_createIntArraySeed_FairLock(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextInt(FAIR_LOCK, rng);
        }
        return seed;
    }

    @Benchmark
    public long[] Threads1_createLongArraySeed_FairLock(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextLong(FAIR_LOCK, rng);
        }
        return seed;
    }

    @Benchmark
    public int[] Threads1_createIntArraySeedBlocks_Sync(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextInt(rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    public long[] Threads1_createLongArraySeedBlocks_Sync(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextLong(rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    public int[] Threads1_createIntArraySeedBlocks_UnfairLock(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextInt(UNFAIR_LOCK, rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    public long[] Threads1_createLongArraySeedBlocks_UnfairLock(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextLong(UNFAIR_LOCK, rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    public int[] Threads1_createIntArraySeedBlocks_FairLock(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextInt(FAIR_LOCK, rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    public long[] Threads1_createLongArraySeedBlocks_FairLock(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextLong(FAIR_LOCK, rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public int[] Threads4_createIntArraySeed_Sync(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextInt(rng);
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public long[] Threads4_createLongArraySeed_Sync(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextLong(rng);
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public int[] Threads4_createIntArraySeed_UnfairLock(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextInt(UNFAIR_LOCK, rng);
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public long[] Threads4_createLongArraySeed_UnfairLock(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextLong(UNFAIR_LOCK, rng);
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public int[] Threads4_createIntArraySeed_FairLock(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextInt(FAIR_LOCK, rng);
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public long[] Threads4_createLongArraySeed_FairLock(SeedRandomSources sources, SeedSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = SeedArrayGenerationPerformance.nextLong(FAIR_LOCK, rng);
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public int[] Threads4_createIntArraySeedBlocks_Sync(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextInt(rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public long[] Threads4_createLongArraySeedBlocks_Sync(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextLong(rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public int[] Threads4_createIntArraySeedBlocks_UnfairLock(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextInt(UNFAIR_LOCK, rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public long[] Threads4_createLongArraySeedBlocks_UnfairLock(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextLong(UNFAIR_LOCK, rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public int[] Threads4_createIntArraySeedBlocks_FairLock(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        int[] seed = new int[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextInt(FAIR_LOCK, rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @Benchmark
    @Threads(value=4)
    public long[] Threads4_createLongArraySeedBlocks_FairLock(SeedRandomSources sources, TestSizes sizes) {
        UniformRandomProvider rng = sources.getGenerator();
        long[] seed = new long[sizes.getSize()];
        for (int i = 0; i < seed.length; i += sizes.getBlockSize()) {
            SeedArrayGenerationPerformance.nextLong(FAIR_LOCK, rng, seed, i, Math.min(i + sizes.getBlockSize(), seed.length));
        }
        return seed;
    }

    @State(value=Scope.Benchmark)
    public static class TestSizes {
        @Param(value={"2", "4", "8", "16", "32", "64", "128"})
        private int size;
        @Param(value={"2", "4", "8", "16", "32", "64", "128"})
        private int blockSize;

        public int getSize() {
            return this.size;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        @Setup
        public void setup() {
            if (this.getBlockSize() > this.getSize()) {
                throw new AssertionError((Object)"Skipping benchmark: Block size is above seed size");
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class SeedSizes {
        @Param(value={"2", "4", "8", "16", "32", "64", "128"})
        private int size;

        public int getSize() {
            return this.size;
        }
    }

    @State(value=Scope.Benchmark)
    public static class SeedRandomSources {
        @Param(value={"WELL_44497_B", "XOR_SHIFT_1024_S_PHI"})
        private String randomSourceName;
        private UniformRandomProvider generator;

        public UniformRandomProvider getGenerator() {
            return this.generator;
        }

        @Setup
        public void setup() {
            this.generator = RandomSource.create((RandomSource)RandomSource.valueOf((String)this.randomSourceName));
        }
    }
}

