/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.sampling.distribution;

import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteInverseCumulativeProbabilityFunction;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.GeometricSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformDiscreteSampler;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class GeometricSamplersPerformance {
    private int value;

    @Benchmark
    public int baseline() {
        return this.value;
    }

    @Benchmark
    public int sample(Sources sources) {
        return sources.getSampler().sample();
    }

    private static class GeometricDiscreteInverseCumulativeProbabilityFunction
    implements DiscreteInverseCumulativeProbabilityFunction {
        private final double log1mProbabilityOfSuccess;

        GeometricDiscreteInverseCumulativeProbabilityFunction(double probabilityOfSuccess) {
            this.log1mProbabilityOfSuccess = Math.log1p(-probabilityOfSuccess);
        }

        public int inverseCumulativeProbability(double cumulativeProbability) {
            return Math.max(0, (int)Math.ceil(Math.log1p(-cumulativeProbability) / this.log1mProbabilityOfSuccess - 1.0));
        }
    }

    @State(value=Scope.Benchmark)
    public static class Sources {
        @Param(value={"SPLIT_MIX_64", "MWC_256", "JDK"})
        private String randomSourceName;
        @Param(value={"0.1", "0.3"})
        private double probabilityOfSuccess;
        @Param(value={"GeometricSampler", "InverseTransformDiscreteSampler"})
        private String samplerType;
        private DiscreteSampler sampler;

        public DiscreteSampler getSampler() {
            return this.sampler;
        }

        @Setup
        public void setup() {
            RandomSource randomSource = RandomSource.valueOf((String)this.randomSourceName);
            RestorableUniformRandomProvider rng = RandomSource.create((RandomSource)randomSource);
            if ("GeometricSampler".equals(this.samplerType)) {
                this.sampler = GeometricSampler.of((UniformRandomProvider)rng, (double)this.probabilityOfSuccess);
            } else {
                GeometricDiscreteInverseCumulativeProbabilityFunction geometricFunction = new GeometricDiscreteInverseCumulativeProbabilityFunction(this.probabilityOfSuccess);
                this.sampler = InverseTransformDiscreteSampler.of((UniformRandomProvider)rng, (DiscreteInverseCumulativeProbabilityFunction)geometricFunction);
            }
        }
    }
}

