/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.sampling.distribution;

import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.examples.jmh.RandomSources;
import org.apache.commons.rng.sampling.distribution.AliasMethodDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteUniformSampler;
import org.apache.commons.rng.sampling.distribution.GeometricSampler;
import org.apache.commons.rng.sampling.distribution.GuideTableDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.LargeMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.MarsagliaTsangWangDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.RejectionInversionZipfSampler;
import org.apache.commons.rng.sampling.distribution.SmallMeanPoissonSampler;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class DiscreteSamplersPerformance {
    private int value;

    @Benchmark
    public int baseline() {
        return this.value;
    }

    @Benchmark
    public int sample(Sources sources) {
        return sources.getSampler().sample();
    }

    @State(value=Scope.Benchmark)
    public static class Sources
    extends RandomSources {
        private static final double[] DISCRETE_PROBABILITIES;
        @Param(value={"DiscreteUniformSampler", "RejectionInversionZipfSampler", "SmallMeanPoissonSampler", "LargeMeanPoissonSampler", "GeometricSampler", "MarsagliaTsangWangDiscreteSampler", "MarsagliaTsangWangPoissonSampler", "MarsagliaTsangWangBinomialSampler", "GuideTableDiscreteSampler", "AliasMethodDiscreteSampler"})
        private String samplerType;
        private DiscreteSampler sampler;

        public DiscreteSampler getSampler() {
            return this.sampler;
        }

        @Override
        @Setup
        public void setup() {
            super.setup();
            UniformRandomProvider rng = this.getGenerator();
            if ("DiscreteUniformSampler".equals(this.samplerType)) {
                this.sampler = DiscreteUniformSampler.of((UniformRandomProvider)rng, (int)-98, (int)76);
            } else if ("RejectionInversionZipfSampler".equals(this.samplerType)) {
                this.sampler = RejectionInversionZipfSampler.of((UniformRandomProvider)rng, (int)43, (double)2.1);
            } else if ("SmallMeanPoissonSampler".equals(this.samplerType)) {
                this.sampler = SmallMeanPoissonSampler.of((UniformRandomProvider)rng, (double)8.9);
            } else if ("LargeMeanPoissonSampler".equals(this.samplerType)) {
                this.sampler = LargeMeanPoissonSampler.of((UniformRandomProvider)rng, (double)41.7);
            } else if ("GeometricSampler".equals(this.samplerType)) {
                this.sampler = GeometricSampler.of((UniformRandomProvider)rng, (double)0.21);
            } else if ("MarsagliaTsangWangDiscreteSampler".equals(this.samplerType)) {
                this.sampler = MarsagliaTsangWangDiscreteSampler.Enumerated.of((UniformRandomProvider)rng, (double[])DISCRETE_PROBABILITIES);
            } else if ("MarsagliaTsangWangPoissonSampler".equals(this.samplerType)) {
                this.sampler = MarsagliaTsangWangDiscreteSampler.Poisson.of((UniformRandomProvider)rng, (double)8.9);
            } else if ("MarsagliaTsangWangBinomialSampler".equals(this.samplerType)) {
                this.sampler = MarsagliaTsangWangDiscreteSampler.Binomial.of((UniformRandomProvider)rng, (int)20, (double)0.33);
            } else if ("GuideTableDiscreteSampler".equals(this.samplerType)) {
                this.sampler = GuideTableDiscreteSampler.of((UniformRandomProvider)rng, (double[])DISCRETE_PROBABILITIES);
            } else if ("AliasMethodDiscreteSampler".equals(this.samplerType)) {
                this.sampler = AliasMethodDiscreteSampler.of((UniformRandomProvider)rng, (double[])DISCRETE_PROBABILITIES);
            }
        }

        static {
            int size = 48;
            DISCRETE_PROBABILITIES = new double[48];
            for (int i = 0; i < 48; ++i) {
                Sources.DISCRETE_PROBABILITIES[i] = ((double)i + 1.0) / 48.0;
            }
        }
    }
}

