/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.core;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class FloatingPointGenerationPerformance {
    @Benchmark
    public long nextDoubleBaseline(LongSource source) {
        return source.nextLong();
    }

    @Benchmark
    public double nextDoubleUsingBitsToDouble(LongSource source) {
        return Double.longBitsToDouble(0x3FF0000000000000L | source.nextLong() >>> 12) - 1.0;
    }

    @Benchmark
    public double nextDoubleUsingMultiply52bits(LongSource source) {
        return (double)(source.nextLong() >>> 12) * 2.220446049250313E-16;
    }

    @Benchmark
    public double nextDoubleUsingMultiply53bits(LongSource source) {
        return (double)(source.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Benchmark
    public int nextFloatBaseline(LongSource source) {
        return source.nextInt();
    }

    @Benchmark
    public float nextFloatUsingBitsToFloat(LongSource source) {
        return Float.intBitsToFloat(0x3F800000 | source.nextInt() >>> 9) - 1.0f;
    }

    @Benchmark
    public float nextFloatUsingMultiply23bits(LongSource source) {
        return (float)(source.nextInt() >>> 9) * 1.1920929E-7f;
    }

    @Benchmark
    public float nextFloatUsingMultiply24bits(LongSource source) {
        return (float)(source.nextInt() >>> 8) * 5.9604645E-8f;
    }

    @State(value=Scope.Benchmark)
    public static class LongSource {
        private long state = ThreadLocalRandom.current().nextLong();

        public final long nextLong() {
            long z = this.state += -7046029254386353131L;
            z = (z ^ z >>> 30) * -4658895280553007687L;
            z = (z ^ z >>> 27) * -7723592293110705685L;
            return z ^ z >>> 31;
        }

        public final int nextInt() {
            long z = this.state += -7046029254386353131L;
            z = (z ^ z >>> 33) * 7109453100751455733L;
            return (int)((z ^ z >>> 28) * -3808689974395783757L >>> 32);
        }
    }
}

