/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh;

import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class GenerationPerformance {
    @Param(value={"1", "100", "10000", "1000000"})
    private int numValues;

    @Benchmark
    public void nextBoolean(Sources sources, Blackhole bh) {
        for (int i = 0; i < this.numValues; ++i) {
            bh.consume(sources.getGenerator().nextBoolean());
        }
    }

    @Benchmark
    public void nextInt(Sources sources, Blackhole bh) {
        for (int i = 0; i < this.numValues; ++i) {
            bh.consume(sources.getGenerator().nextInt());
        }
    }

    @Benchmark
    public void nextIntN(Sources sources, Blackhole bh) {
        int n = 10;
        for (int i = 0; i < this.numValues; ++i) {
            bh.consume(sources.getGenerator().nextInt(10));
        }
    }

    @Benchmark
    public void nextLong(Sources sources, Blackhole bh) {
        for (int i = 0; i < this.numValues; ++i) {
            bh.consume(sources.getGenerator().nextLong());
        }
    }

    @Benchmark
    public void nextLongN(Sources sources, Blackhole bh) {
        long n = 0xFFFFFFFEL;
        for (int i = 0; i < this.numValues; ++i) {
            bh.consume(sources.getGenerator().nextLong(0xFFFFFFFEL));
        }
    }

    @Benchmark
    public void nextFloat(Sources sources, Blackhole bh) {
        for (int i = 0; i < this.numValues; ++i) {
            bh.consume(sources.getGenerator().nextFloat());
        }
    }

    @Benchmark
    public void nextDouble(Sources sources, Blackhole bh) {
        for (int i = 0; i < this.numValues; ++i) {
            bh.consume(sources.getGenerator().nextDouble());
        }
    }

    @Benchmark
    public void nextBytes(Sources sources, Blackhole bh) {
        byte[] result = new byte[this.numValues];
        sources.getGenerator().nextBytes(result);
        bh.consume((Object)result);
    }

    @State(value=Scope.Benchmark)
    public static class Sources {
        @Param(value={"JDK", "WELL_512_A", "WELL_1024_A", "WELL_19937_A", "WELL_19937_C", "WELL_44497_A", "WELL_44497_B", "MT", "ISAAC", "SPLIT_MIX_64", "MWC_256", "KISS", "XOR_SHIFT_1024_S", "TWO_CMRES", "MT_64"})
        private String randomSourceName;
        private UniformRandomProvider provider;

        public UniformRandomProvider getGenerator() {
            return this.provider;
        }

        @Setup
        public void setup() {
            RandomSource randomSource = RandomSource.valueOf((String)this.randomSourceName);
            this.provider = RandomSource.create((RandomSource)randomSource);
        }
    }
}

