/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.Iterator;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.sourceforge.cobertura.coveragedata.LightClassmapListener;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.SwallowedExceptionListener;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.commons.pool2.impl.EvictionPolicy;
import org.apache.commons.pool2.impl.EvictionTimer;

public abstract class BaseGenericObjectPool<T> {
    public static final transient int[] __cobertura_counters;
    public static final int MEAN_TIMING_STATS_CACHE_SIZE = 100;
    private volatile int maxTotal;
    private volatile boolean blockWhenExhausted;
    private volatile long maxWaitMillis;
    private volatile boolean lifo;
    private final boolean fairness;
    private volatile boolean testOnCreate;
    private volatile boolean testOnBorrow;
    private volatile boolean testOnReturn;
    private volatile boolean testWhileIdle;
    private volatile long timeBetweenEvictionRunsMillis;
    private volatile int numTestsPerEvictionRun;
    private volatile long minEvictableIdleTimeMillis;
    private volatile long softMinEvictableIdleTimeMillis;
    private volatile EvictionPolicy<T> evictionPolicy;
    final Object closeLock;
    volatile boolean closed;
    final Object evictionLock;
    private Evictor evictor;
    EvictionIterator evictionIterator;
    private final WeakReference<ClassLoader> factoryClassLoader;
    private final ObjectName oname;
    private final String creationStackTrace;
    private final AtomicLong borrowedCount;
    private final AtomicLong returnedCount;
    final AtomicLong createdCount;
    final AtomicLong destroyedCount;
    final AtomicLong destroyedByEvictorCount;
    final AtomicLong destroyedByBorrowValidationCount;
    private final StatsStore activeTimes;
    private final StatsStore idleTimes;
    private final StatsStore waitTimes;
    private final AtomicLong maxBorrowWaitTimeMillis;
    private volatile SwallowedExceptionListener swallowedExceptionListener;

    /*
     * WARNING - void declaration
     */
    public BaseGenericObjectPool(BaseObjectPoolConfig baseObjectPoolConfig, String string, String string2) {
        void config;
        int n = 0;
        __cobertura_counters[30] = __cobertura_counters[30] + 1;
        __cobertura_counters[2] = __cobertura_counters[2] + 1;
        this.maxTotal = -1;
        __cobertura_counters[3] = __cobertura_counters[3] + 1;
        this.blockWhenExhausted = true;
        __cobertura_counters[4] = __cobertura_counters[4] + 1;
        this.maxWaitMillis = -1L;
        __cobertura_counters[5] = __cobertura_counters[5] + 1;
        this.lifo = true;
        __cobertura_counters[6] = __cobertura_counters[6] + 1;
        this.testOnCreate = false;
        __cobertura_counters[7] = __cobertura_counters[7] + 1;
        this.testOnBorrow = false;
        __cobertura_counters[8] = __cobertura_counters[8] + 1;
        this.testOnReturn = false;
        __cobertura_counters[9] = __cobertura_counters[9] + 1;
        this.testWhileIdle = false;
        __cobertura_counters[10] = __cobertura_counters[10] + 1;
        this.timeBetweenEvictionRunsMillis = -1L;
        __cobertura_counters[11] = __cobertura_counters[11] + 1;
        this.numTestsPerEvictionRun = 3;
        __cobertura_counters[12] = __cobertura_counters[12] + 1;
        this.minEvictableIdleTimeMillis = 1800000L;
        __cobertura_counters[13] = __cobertura_counters[13] + 1;
        this.softMinEvictableIdleTimeMillis = -1L;
        __cobertura_counters[14] = __cobertura_counters[14] + 1;
        this.closeLock = new Object();
        __cobertura_counters[15] = __cobertura_counters[15] + 1;
        this.closed = false;
        __cobertura_counters[16] = __cobertura_counters[16] + 1;
        this.evictionLock = new Object();
        __cobertura_counters[17] = __cobertura_counters[17] + 1;
        this.evictor = null;
        __cobertura_counters[18] = __cobertura_counters[18] + 1;
        this.evictionIterator = null;
        __cobertura_counters[19] = __cobertura_counters[19] + 1;
        this.borrowedCount = new AtomicLong(0L);
        __cobertura_counters[20] = __cobertura_counters[20] + 1;
        this.returnedCount = new AtomicLong(0L);
        __cobertura_counters[21] = __cobertura_counters[21] + 1;
        this.createdCount = new AtomicLong(0L);
        __cobertura_counters[22] = __cobertura_counters[22] + 1;
        this.destroyedCount = new AtomicLong(0L);
        __cobertura_counters[23] = __cobertura_counters[23] + 1;
        this.destroyedByEvictorCount = new AtomicLong(0L);
        __cobertura_counters[24] = __cobertura_counters[24] + 1;
        this.destroyedByBorrowValidationCount = new AtomicLong(0L);
        __cobertura_counters[25] = __cobertura_counters[25] + 1;
        this.activeTimes = new StatsStore(this, 100);
        __cobertura_counters[26] = __cobertura_counters[26] + 1;
        this.idleTimes = new StatsStore(this, 100);
        __cobertura_counters[27] = __cobertura_counters[27] + 1;
        this.waitTimes = new StatsStore(this, 100);
        __cobertura_counters[28] = __cobertura_counters[28] + 1;
        this.maxBorrowWaitTimeMillis = new AtomicLong(0L);
        __cobertura_counters[29] = __cobertura_counters[29] + 1;
        this.swallowedExceptionListener = null;
        __cobertura_counters[31] = __cobertura_counters[31] + 1;
        n = 33;
        if (config.getJmxEnabled()) {
            void jmxNamePrefix;
            void jmxNameBase;
            __cobertura_counters[32] = __cobertura_counters[32] + 1;
            n = 0;
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
            this.oname = this.jmxRegister((BaseObjectPoolConfig)config, (String)jmxNameBase, (String)jmxNamePrefix);
        } else {
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[35] = __cobertura_counters[35] + 1;
            this.oname = null;
        }
        __cobertura_counters[36] = __cobertura_counters[36] + 1;
        this.creationStackTrace = this.getStackTrace(new Exception());
        __cobertura_counters[37] = __cobertura_counters[37] + 1;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        __cobertura_counters[38] = __cobertura_counters[38] + 1;
        n = 40;
        if (cl == null) {
            __cobertura_counters[39] = __cobertura_counters[39] + 1;
            n = 0;
            __cobertura_counters[41] = __cobertura_counters[41] + 1;
            this.factoryClassLoader = null;
        } else {
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[42] = __cobertura_counters[42] + 1;
            this.factoryClassLoader = new WeakReference<ClassLoader>(cl);
        }
        __cobertura_counters[43] = __cobertura_counters[43] + 1;
        this.fairness = config.getFairness();
        __cobertura_counters[44] = __cobertura_counters[44] + 1;
    }

    public final int getMaxTotal() {
        int n = 0;
        __cobertura_counters[45] = __cobertura_counters[45] + 1;
        return this.maxTotal;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMaxTotal(int n) {
        void maxTotal;
        int n2 = 0;
        __cobertura_counters[46] = __cobertura_counters[46] + 1;
        this.maxTotal = maxTotal;
        __cobertura_counters[47] = __cobertura_counters[47] + 1;
    }

    public final boolean getBlockWhenExhausted() {
        int n = 0;
        __cobertura_counters[48] = __cobertura_counters[48] + 1;
        return this.blockWhenExhausted;
    }

    /*
     * WARNING - void declaration
     */
    public final void setBlockWhenExhausted(boolean bl) {
        void blockWhenExhausted;
        int n = 0;
        __cobertura_counters[49] = __cobertura_counters[49] + 1;
        this.blockWhenExhausted = blockWhenExhausted;
        __cobertura_counters[50] = __cobertura_counters[50] + 1;
    }

    public final long getMaxWaitMillis() {
        int n = 0;
        __cobertura_counters[51] = __cobertura_counters[51] + 1;
        return this.maxWaitMillis;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMaxWaitMillis(long l) {
        void maxWaitMillis;
        int n = 0;
        __cobertura_counters[52] = __cobertura_counters[52] + 1;
        this.maxWaitMillis = maxWaitMillis;
        __cobertura_counters[53] = __cobertura_counters[53] + 1;
    }

    public final boolean getLifo() {
        int n = 0;
        __cobertura_counters[54] = __cobertura_counters[54] + 1;
        return this.lifo;
    }

    public final boolean getFairness() {
        int n = 0;
        __cobertura_counters[55] = __cobertura_counters[55] + 1;
        return this.fairness;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLifo(boolean bl) {
        void lifo;
        int n = 0;
        __cobertura_counters[56] = __cobertura_counters[56] + 1;
        this.lifo = lifo;
        __cobertura_counters[57] = __cobertura_counters[57] + 1;
    }

    public final boolean getTestOnCreate() {
        int n = 0;
        __cobertura_counters[58] = __cobertura_counters[58] + 1;
        return this.testOnCreate;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTestOnCreate(boolean bl) {
        void testOnCreate;
        int n = 0;
        __cobertura_counters[59] = __cobertura_counters[59] + 1;
        this.testOnCreate = testOnCreate;
        __cobertura_counters[60] = __cobertura_counters[60] + 1;
    }

    public final boolean getTestOnBorrow() {
        int n = 0;
        __cobertura_counters[61] = __cobertura_counters[61] + 1;
        return this.testOnBorrow;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTestOnBorrow(boolean bl) {
        void testOnBorrow;
        int n = 0;
        __cobertura_counters[62] = __cobertura_counters[62] + 1;
        this.testOnBorrow = testOnBorrow;
        __cobertura_counters[63] = __cobertura_counters[63] + 1;
    }

    public final boolean getTestOnReturn() {
        int n = 0;
        __cobertura_counters[64] = __cobertura_counters[64] + 1;
        return this.testOnReturn;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTestOnReturn(boolean bl) {
        void testOnReturn;
        int n = 0;
        __cobertura_counters[65] = __cobertura_counters[65] + 1;
        this.testOnReturn = testOnReturn;
        __cobertura_counters[66] = __cobertura_counters[66] + 1;
    }

    public final boolean getTestWhileIdle() {
        int n = 0;
        __cobertura_counters[67] = __cobertura_counters[67] + 1;
        return this.testWhileIdle;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTestWhileIdle(boolean bl) {
        void testWhileIdle;
        int n = 0;
        __cobertura_counters[68] = __cobertura_counters[68] + 1;
        this.testWhileIdle = testWhileIdle;
        __cobertura_counters[69] = __cobertura_counters[69] + 1;
    }

    public final long getTimeBetweenEvictionRunsMillis() {
        int n = 0;
        __cobertura_counters[70] = __cobertura_counters[70] + 1;
        return this.timeBetweenEvictionRunsMillis;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTimeBetweenEvictionRunsMillis(long l) {
        void timeBetweenEvictionRunsMillis;
        int n = 0;
        __cobertura_counters[71] = __cobertura_counters[71] + 1;
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        __cobertura_counters[72] = __cobertura_counters[72] + 1;
        this.startEvictor((long)timeBetweenEvictionRunsMillis);
        __cobertura_counters[73] = __cobertura_counters[73] + 1;
    }

    public final int getNumTestsPerEvictionRun() {
        int n = 0;
        __cobertura_counters[74] = __cobertura_counters[74] + 1;
        return this.numTestsPerEvictionRun;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNumTestsPerEvictionRun(int n) {
        void numTestsPerEvictionRun;
        int n2 = 0;
        __cobertura_counters[75] = __cobertura_counters[75] + 1;
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        __cobertura_counters[76] = __cobertura_counters[76] + 1;
    }

    public final long getMinEvictableIdleTimeMillis() {
        int n = 0;
        __cobertura_counters[77] = __cobertura_counters[77] + 1;
        return this.minEvictableIdleTimeMillis;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMinEvictableIdleTimeMillis(long l) {
        void minEvictableIdleTimeMillis;
        int n = 0;
        __cobertura_counters[78] = __cobertura_counters[78] + 1;
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        __cobertura_counters[79] = __cobertura_counters[79] + 1;
    }

    public final long getSoftMinEvictableIdleTimeMillis() {
        int n = 0;
        __cobertura_counters[80] = __cobertura_counters[80] + 1;
        return this.softMinEvictableIdleTimeMillis;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSoftMinEvictableIdleTimeMillis(long l) {
        void softMinEvictableIdleTimeMillis;
        int n = 0;
        __cobertura_counters[81] = __cobertura_counters[81] + 1;
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
        __cobertura_counters[82] = __cobertura_counters[82] + 1;
    }

    public final String getEvictionPolicyClassName() {
        int n = 0;
        __cobertura_counters[83] = __cobertura_counters[83] + 1;
        return this.evictionPolicy.getClass().getName();
    }

    /*
     * WARNING - void declaration
     */
    public final void setEvictionPolicyClassName(String string) {
        int n;
        void evictionPolicyClassName;
        int n2 = 0;
        try {
            Class<?> clazz;
            try {
                __cobertura_counters[84] = __cobertura_counters[84] + 1;
                __cobertura_counters[86] = __cobertura_counters[86] + 1;
                __cobertura_counters[85] = __cobertura_counters[85] + 1;
                clazz = Class.forName((String)evictionPolicyClassName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                __cobertura_counters[87] = __cobertura_counters[87] + 1;
                ClassNotFoundException e = classNotFoundException;
                __cobertura_counters[88] = __cobertura_counters[88] + 1;
                clazz = Class.forName((String)evictionPolicyClassName);
            }
            __cobertura_counters[89] = __cobertura_counters[89] + 1;
            __cobertura_counters[90] = __cobertura_counters[90] + 1;
            Object policy = clazz.newInstance();
            __cobertura_counters[91] = __cobertura_counters[91] + 1;
            n2 = 93;
            if (policy instanceof EvictionPolicy) {
                __cobertura_counters[92] = __cobertura_counters[92] + 1;
                n2 = 0;
                __cobertura_counters[94] = __cobertura_counters[94] + 1;
                EvictionPolicy evicPolicy = (EvictionPolicy)policy;
                __cobertura_counters[95] = __cobertura_counters[95] + 1;
                this.evictionPolicy = evicPolicy;
            }
            n = n2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            __cobertura_counters[96] = __cobertura_counters[96] + 1;
            ClassNotFoundException e = classNotFoundException;
            __cobertura_counters[97] = __cobertura_counters[97] + 1;
            throw new IllegalArgumentException("Unable to create EvictionPolicy instance of type " + (String)evictionPolicyClassName, e);
        }
        catch (InstantiationException instantiationException) {
            __cobertura_counters[98] = __cobertura_counters[98] + 1;
            InstantiationException e = instantiationException;
            __cobertura_counters[99] = __cobertura_counters[99] + 1;
            throw new IllegalArgumentException("Unable to create EvictionPolicy instance of type " + (String)evictionPolicyClassName, e);
        }
        catch (IllegalAccessException illegalAccessException) {
            __cobertura_counters[100] = __cobertura_counters[100] + 1;
            IllegalAccessException e = illegalAccessException;
            __cobertura_counters[101] = __cobertura_counters[101] + 1;
            throw new IllegalArgumentException("Unable to create EvictionPolicy instance of type " + (String)evictionPolicyClassName, e);
        }
        __cobertura_counters[n] = __cobertura_counters[n] + 1;
        n2 = 0;
        __cobertura_counters[102] = __cobertura_counters[102] + 1;
        __cobertura_counters[103] = __cobertura_counters[103] + 1;
    }

    public abstract void close();

    public final boolean isClosed() {
        int n = 0;
        __cobertura_counters[104] = __cobertura_counters[104] + 1;
        return this.closed;
    }

    public abstract void evict() throws Exception;

    protected EvictionPolicy<T> getEvictionPolicy() {
        int n = 0;
        __cobertura_counters[105] = __cobertura_counters[105] + 1;
        return this.evictionPolicy;
    }

    final void assertOpen() throws IllegalStateException {
        int n = 0;
        __cobertura_counters[106] = __cobertura_counters[106] + 1;
        n = 108;
        if (this.isClosed()) {
            __cobertura_counters[107] = __cobertura_counters[107] + 1;
            n = 0;
            __cobertura_counters[109] = __cobertura_counters[109] + 1;
            throw new IllegalStateException("Pool not open");
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[110] = __cobertura_counters[110] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    final void startEvictor(long l) {
        int n = 0;
        __cobertura_counters[111] = __cobertura_counters[111] + 1;
        Object object = this.evictionLock;
        synchronized (object) {
            void delay;
            __cobertura_counters[112] = __cobertura_counters[112] + 1;
            n = 114;
            if (null != this.evictor) {
                __cobertura_counters[113] = __cobertura_counters[113] + 1;
                n = 0;
                __cobertura_counters[115] = __cobertura_counters[115] + 1;
                EvictionTimer.cancel(this.evictor);
                __cobertura_counters[116] = __cobertura_counters[116] + 1;
                this.evictor = null;
                __cobertura_counters[117] = __cobertura_counters[117] + 1;
                this.evictionIterator = null;
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[118] = __cobertura_counters[118] + 1;
            n = 120;
            if (delay > 0L) {
                __cobertura_counters[119] = __cobertura_counters[119] + 1;
                n = 0;
                __cobertura_counters[121] = __cobertura_counters[121] + 1;
                this.evictor = new Evictor(this);
                __cobertura_counters[122] = __cobertura_counters[122] + 1;
                EvictionTimer.schedule(this.evictor, (long)delay, (long)delay);
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[123] = __cobertura_counters[123] + 1;
        }
        __cobertura_counters[124] = __cobertura_counters[124] + 1;
    }

    abstract void ensureMinIdle() throws Exception;

    public final ObjectName getJmxName() {
        int n = 0;
        __cobertura_counters[125] = __cobertura_counters[125] + 1;
        return this.oname;
    }

    public final String getCreationStackTrace() {
        int n = 0;
        __cobertura_counters[126] = __cobertura_counters[126] + 1;
        return this.creationStackTrace;
    }

    public final long getBorrowedCount() {
        int n = 0;
        __cobertura_counters[127] = __cobertura_counters[127] + 1;
        return this.borrowedCount.get();
    }

    public final long getReturnedCount() {
        int n = 0;
        __cobertura_counters[128] = __cobertura_counters[128] + 1;
        return this.returnedCount.get();
    }

    public final long getCreatedCount() {
        int n = 0;
        __cobertura_counters[129] = __cobertura_counters[129] + 1;
        return this.createdCount.get();
    }

    public final long getDestroyedCount() {
        int n = 0;
        __cobertura_counters[130] = __cobertura_counters[130] + 1;
        return this.destroyedCount.get();
    }

    public final long getDestroyedByEvictorCount() {
        int n = 0;
        __cobertura_counters[131] = __cobertura_counters[131] + 1;
        return this.destroyedByEvictorCount.get();
    }

    public final long getDestroyedByBorrowValidationCount() {
        int n = 0;
        __cobertura_counters[132] = __cobertura_counters[132] + 1;
        return this.destroyedByBorrowValidationCount.get();
    }

    public final long getMeanActiveTimeMillis() {
        int n = 0;
        __cobertura_counters[133] = __cobertura_counters[133] + 1;
        return this.activeTimes.getMean();
    }

    public final long getMeanIdleTimeMillis() {
        int n = 0;
        __cobertura_counters[134] = __cobertura_counters[134] + 1;
        return this.idleTimes.getMean();
    }

    public final long getMeanBorrowWaitTimeMillis() {
        int n = 0;
        __cobertura_counters[135] = __cobertura_counters[135] + 1;
        return this.waitTimes.getMean();
    }

    public final long getMaxBorrowWaitTimeMillis() {
        int n = 0;
        __cobertura_counters[136] = __cobertura_counters[136] + 1;
        return this.maxBorrowWaitTimeMillis.get();
    }

    public abstract int getNumIdle();

    public final SwallowedExceptionListener getSwallowedExceptionListener() {
        int n = 0;
        __cobertura_counters[137] = __cobertura_counters[137] + 1;
        return this.swallowedExceptionListener;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSwallowedExceptionListener(SwallowedExceptionListener swallowedExceptionListener) {
        void swallowedExceptionListener2;
        int n = 0;
        __cobertura_counters[138] = __cobertura_counters[138] + 1;
        this.swallowedExceptionListener = swallowedExceptionListener2;
        __cobertura_counters[139] = __cobertura_counters[139] + 1;
    }

    /*
     * WARNING - void declaration
     */
    final void swallowException(Exception exception) {
        int n = 0;
        __cobertura_counters[140] = __cobertura_counters[140] + 1;
        SwallowedExceptionListener listener = this.getSwallowedExceptionListener();
        __cobertura_counters[141] = __cobertura_counters[141] + 1;
        n = 143;
        if (listener == null) {
            __cobertura_counters[142] = __cobertura_counters[142] + 1;
            n = 0;
            __cobertura_counters[144] = __cobertura_counters[144] + 1;
            return;
        }
        try {
            void e;
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[145] = __cobertura_counters[145] + 1;
            listener.onSwallowException((Exception)e);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            __cobertura_counters[146] = __cobertura_counters[146] + 1;
            OutOfMemoryError oome = outOfMemoryError;
            __cobertura_counters[147] = __cobertura_counters[147] + 1;
            throw oome;
        }
        catch (VirtualMachineError virtualMachineError) {
            __cobertura_counters[148] = __cobertura_counters[148] + 1;
            VirtualMachineError vme = virtualMachineError;
            __cobertura_counters[149] = __cobertura_counters[149] + 1;
            throw vme;
        }
        catch (Throwable throwable) {
            __cobertura_counters[150] = __cobertura_counters[150] + 1;
            Throwable throwable2 = throwable;
        }
        __cobertura_counters[151] = __cobertura_counters[151] + 1;
        __cobertura_counters[152] = __cobertura_counters[152] + 1;
    }

    /*
     * WARNING - void declaration
     */
    final void updateStatsBorrow(PooledObject<T> pooledObject, long l) {
        block2: {
            long currentMax;
            void waitTime;
            void p;
            int n = 0;
            __cobertura_counters[153] = __cobertura_counters[153] + 1;
            this.borrowedCount.incrementAndGet();
            __cobertura_counters[154] = __cobertura_counters[154] + 1;
            this.idleTimes.add(p.getIdleTimeMillis());
            __cobertura_counters[155] = __cobertura_counters[155] + 1;
            this.waitTimes.add((long)waitTime);
            do {
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[156] = __cobertura_counters[156] + 1;
                currentMax = this.maxBorrowWaitTimeMillis.get();
                __cobertura_counters[157] = __cobertura_counters[157] + 1;
                n = 159;
                if (currentMax >= waitTime) {
                    __cobertura_counters[158] = __cobertura_counters[158] + 1;
                    n = 0;
                    __cobertura_counters[160] = __cobertura_counters[160] + 1;
                    break block2;
                }
                int n3 = n;
                __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                n = 0;
                __cobertura_counters[161] = __cobertura_counters[161] + 1;
                n = 163;
            } while (!this.maxBorrowWaitTimeMillis.compareAndSet(currentMax, (long)waitTime));
            __cobertura_counters[162] = __cobertura_counters[162] + 1;
            n = 0;
        }
        __cobertura_counters[164] = __cobertura_counters[164] + 1;
    }

    /*
     * WARNING - void declaration
     */
    final void updateStatsReturn(long l) {
        void activeTime;
        int n = 0;
        __cobertura_counters[165] = __cobertura_counters[165] + 1;
        this.returnedCount.incrementAndGet();
        __cobertura_counters[166] = __cobertura_counters[166] + 1;
        this.activeTimes.add((long)activeTime);
        __cobertura_counters[167] = __cobertura_counters[167] + 1;
    }

    final void jmxUnregister() {
        int n = 0;
        __cobertura_counters[168] = __cobertura_counters[168] + 1;
        n = 170;
        if (this.oname != null) {
            __cobertura_counters[169] = __cobertura_counters[169] + 1;
            n = 0;
            try {
                __cobertura_counters[171] = __cobertura_counters[171] + 1;
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.oname);
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                __cobertura_counters[172] = __cobertura_counters[172] + 1;
                MBeanRegistrationException e = mBeanRegistrationException;
                __cobertura_counters[173] = __cobertura_counters[173] + 1;
                this.swallowException(e);
                __cobertura_counters[177] = __cobertura_counters[177] + 1;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                __cobertura_counters[174] = __cobertura_counters[174] + 1;
                InstanceNotFoundException e = instanceNotFoundException;
                __cobertura_counters[175] = __cobertura_counters[175] + 1;
                this.swallowException(e);
            }
            __cobertura_counters[176] = __cobertura_counters[176] + 1;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[178] = __cobertura_counters[178] + 1;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private ObjectName jmxRegister(BaseObjectPoolConfig var1_1, String var2_2, String var3_3) {
        var4_4 = 0;
        BaseGenericObjectPool.__cobertura_counters[179] = BaseGenericObjectPool.__cobertura_counters[179] + 1;
        objectName = null;
        BaseGenericObjectPool.__cobertura_counters[180] = BaseGenericObjectPool.__cobertura_counters[180] + 1;
        mbs = ManagementFactory.getPlatformMBeanServer();
        BaseGenericObjectPool.__cobertura_counters[181] = BaseGenericObjectPool.__cobertura_counters[181] + 1;
        i = 1;
        BaseGenericObjectPool.__cobertura_counters[182] = BaseGenericObjectPool.__cobertura_counters[182] + 1;
        registered = false;
        BaseGenericObjectPool.__cobertura_counters[183] = BaseGenericObjectPool.__cobertura_counters[183] + 1;
        base = config.getJmxNameBase();
        BaseGenericObjectPool.__cobertura_counters[184] = BaseGenericObjectPool.__cobertura_counters[184] + 1;
        var4_4 = 186;
        if (base == null) {
            BaseGenericObjectPool.__cobertura_counters[185] = BaseGenericObjectPool.__cobertura_counters[185] + 1;
            var4_4 = 0;
            BaseGenericObjectPool.__cobertura_counters[187] = BaseGenericObjectPool.__cobertura_counters[187] + 1;
            base = jmxNameBase;
        }
        while (true) lbl-1000:
        // 6 sources

        {
            v0 = var4_4;
            BaseGenericObjectPool.__cobertura_counters[v0] = BaseGenericObjectPool.__cobertura_counters[v0] + 1;
            var4_4 = 0;
            BaseGenericObjectPool.__cobertura_counters[188] = BaseGenericObjectPool.__cobertura_counters[188] + 1;
            var4_4 = 190;
            if (registered) ** break;
            BaseGenericObjectPool.__cobertura_counters[189] = BaseGenericObjectPool.__cobertura_counters[189] + 1;
            var4_4 = 0;
            try {
                BaseGenericObjectPool.__cobertura_counters[191] = BaseGenericObjectPool.__cobertura_counters[191] + 1;
                var4_4 = 193;
                if (i == 1) {
                    BaseGenericObjectPool.__cobertura_counters[192] = BaseGenericObjectPool.__cobertura_counters[192] + 1;
                    var4_4 = 0;
                    BaseGenericObjectPool.__cobertura_counters[194] = BaseGenericObjectPool.__cobertura_counters[194] + 1;
                    objName = new ObjectName(base + jmxNamePrefix);
                } else {
                    v1 = var4_4;
                    BaseGenericObjectPool.__cobertura_counters[v1] = BaseGenericObjectPool.__cobertura_counters[v1] + 1;
                    var4_4 = 0;
                    BaseGenericObjectPool.__cobertura_counters[195] = BaseGenericObjectPool.__cobertura_counters[195] + 1;
                    objName = new ObjectName(base + jmxNamePrefix + i);
                }
                BaseGenericObjectPool.__cobertura_counters[196] = BaseGenericObjectPool.__cobertura_counters[196] + 1;
                mbs.registerMBean(this, objName);
                BaseGenericObjectPool.__cobertura_counters[197] = BaseGenericObjectPool.__cobertura_counters[197] + 1;
                objectName = objName;
                BaseGenericObjectPool.__cobertura_counters[198] = BaseGenericObjectPool.__cobertura_counters[198] + 1;
                registered = true;
            }
            catch (MalformedObjectNameException v2) {
                BaseGenericObjectPool.__cobertura_counters[199] = BaseGenericObjectPool.__cobertura_counters[199] + 1;
                e /* !! */  = v2;
                BaseGenericObjectPool.__cobertura_counters[200] = BaseGenericObjectPool.__cobertura_counters[200] + 1;
                var4_4 = 202;
                if (!"pool".equals(jmxNamePrefix)) ** GOTO lbl-1000
                BaseGenericObjectPool.__cobertura_counters[201] = BaseGenericObjectPool.__cobertura_counters[201] + 1;
                var4_4 = 0;
                BaseGenericObjectPool.__cobertura_counters[203] = BaseGenericObjectPool.__cobertura_counters[203] + 1;
                var4_4 = 205;
                if (jmxNameBase.equals(base)) {
                    BaseGenericObjectPool.__cobertura_counters[204] = BaseGenericObjectPool.__cobertura_counters[204] + 1;
                    var4_4 = 0;
                    BaseGenericObjectPool.__cobertura_counters[206] = BaseGenericObjectPool.__cobertura_counters[206] + 1;
                    registered = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = var4_4;
                    BaseGenericObjectPool.__cobertura_counters[v3] = BaseGenericObjectPool.__cobertura_counters[v3] + 1;
                    var4_4 = 0;
                    BaseGenericObjectPool.__cobertura_counters[207] = BaseGenericObjectPool.__cobertura_counters[207] + 1;
                    jmxNamePrefix = "pool";
                    BaseGenericObjectPool.__cobertura_counters[208] = BaseGenericObjectPool.__cobertura_counters[208] + 1;
                    base = jmxNameBase;
                }
                BaseGenericObjectPool.__cobertura_counters[216] = BaseGenericObjectPool.__cobertura_counters[216] + 1;
            }
            catch (InstanceAlreadyExistsException v4) {
                BaseGenericObjectPool.__cobertura_counters[209] = BaseGenericObjectPool.__cobertura_counters[209] + 1;
                e /* !! */  = v4;
                BaseGenericObjectPool.__cobertura_counters[210] = BaseGenericObjectPool.__cobertura_counters[210] + 1;
                ++i;
                BaseGenericObjectPool.__cobertura_counters[217] = BaseGenericObjectPool.__cobertura_counters[217] + 1;
            }
            catch (MBeanRegistrationException v5) {
                BaseGenericObjectPool.__cobertura_counters[211] = BaseGenericObjectPool.__cobertura_counters[211] + 1;
                e /* !! */  = v5;
                BaseGenericObjectPool.__cobertura_counters[212] = BaseGenericObjectPool.__cobertura_counters[212] + 1;
                registered = true;
                BaseGenericObjectPool.__cobertura_counters[218] = BaseGenericObjectPool.__cobertura_counters[218] + 1;
            }
            catch (NotCompliantMBeanException v6) {
                BaseGenericObjectPool.__cobertura_counters[213] = BaseGenericObjectPool.__cobertura_counters[213] + 1;
                e /* !! */  = v6;
                BaseGenericObjectPool.__cobertura_counters[214] = BaseGenericObjectPool.__cobertura_counters[214] + 1;
                registered = true;
                BaseGenericObjectPool.__cobertura_counters[219] = BaseGenericObjectPool.__cobertura_counters[219] + 1;
                continue;
            }
            BaseGenericObjectPool.__cobertura_counters[215] = BaseGenericObjectPool.__cobertura_counters[215] + 1;
            continue;
            break;
        }
        ** GOTO lbl-1000
        v7 = var4_4;
        BaseGenericObjectPool.__cobertura_counters[v7] = BaseGenericObjectPool.__cobertura_counters[v7] + 1;
        var4_4 = 0;
        BaseGenericObjectPool.__cobertura_counters[220] = BaseGenericObjectPool.__cobertura_counters[220] + 1;
        return objectName;
    }

    /*
     * WARNING - void declaration
     */
    private String getStackTrace(Exception exception) {
        void e;
        int n = 0;
        __cobertura_counters[221] = __cobertura_counters[221] + 1;
        StringWriter w = new StringWriter();
        __cobertura_counters[222] = __cobertura_counters[222] + 1;
        PrintWriter pw = new PrintWriter(w);
        __cobertura_counters[223] = __cobertura_counters[223] + 1;
        e.printStackTrace(pw);
        __cobertura_counters[224] = __cobertura_counters[224] + 1;
        return ((Object)w).toString();
    }

    static /* synthetic */ WeakReference access$000(BaseGenericObjectPool baseGenericObjectPool) {
        BaseGenericObjectPool x0;
        BaseGenericObjectPool.__cobertura_init();
        int n = 0;
        __cobertura_counters[1] = __cobertura_counters[1] + 1;
        return x0.factoryClassLoader;
    }

    static {
        BaseGenericObjectPool.__cobertura_init();
    }

    public static void __cobertura_init() {
        if (__cobertura_counters == null) {
            __cobertura_counters = new int[225];
            TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/BaseGenericObjectPool");
        }
    }

    public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.putLineTouchPoint(53, 1, "access$000", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;)Ljava/lang/ref/WeakReference;");
        lightClassmapListener2.putLineTouchPoint(63, 2, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(65, 3, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(67, 4, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(69, 5, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(71, 6, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(73, 7, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(75, 8, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(77, 9, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(79, 10, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(81, 11, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(83, 12, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(85, 13, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(91, 14, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(92, 15, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(93, 16, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(94, 17, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(95, 18, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(108, 19, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(109, 20, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(110, 21, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(111, 22, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(112, 23, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(113, 24, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(114, 25, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(115, 26, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(116, 27, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(117, 28, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(118, 29, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(131, 30, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(132, 31, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(132, 33, 32);
        lightClassmapListener2.putLineTouchPoint(133, 34, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(135, 35, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(139, 36, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(142, 37, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(143, 38, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(143, 40, 39);
        lightClassmapListener2.putLineTouchPoint(144, 41, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(146, 42, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(149, 43, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(150, 44, "<init>", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(165, 45, "getMaxTotal", "()I");
        lightClassmapListener2.putLineTouchPoint(180, 46, "setMaxTotal", "(I)V");
        lightClassmapListener2.putLineTouchPoint(181, 47, "setMaxTotal", "(I)V");
        lightClassmapListener2.putLineTouchPoint(194, 48, "getBlockWhenExhausted", "()Z");
        lightClassmapListener2.putLineTouchPoint(209, 49, "setBlockWhenExhausted", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(210, 50, "setBlockWhenExhausted", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(226, 51, "getMaxWaitMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(244, 52, "setMaxWaitMillis", "(J)V");
        lightClassmapListener2.putLineTouchPoint(245, 53, "setMaxWaitMillis", "(J)V");
        lightClassmapListener2.putLineTouchPoint(260, 54, "getLifo", "()Z");
        lightClassmapListener2.putLineTouchPoint(271, 55, "getFairness", "()Z");
        lightClassmapListener2.putLineTouchPoint(287, 56, "setLifo", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(288, 57, "setLifo", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(305, 58, "getTestOnCreate", "()Z");
        lightClassmapListener2.putLineTouchPoint(324, 59, "setTestOnCreate", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(325, 60, "setTestOnCreate", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(341, 61, "getTestOnBorrow", "()Z");
        lightClassmapListener2.putLineTouchPoint(359, 62, "setTestOnBorrow", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(360, 63, "setTestOnBorrow", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(375, 64, "getTestOnReturn", "()Z");
        lightClassmapListener2.putLineTouchPoint(392, 65, "setTestOnReturn", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(393, 66, "setTestOnReturn", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(409, 67, "getTestWhileIdle", "()Z");
        lightClassmapListener2.putLineTouchPoint(429, 68, "setTestWhileIdle", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(430, 69, "setTestWhileIdle", "(Z)V");
        lightClassmapListener2.putLineTouchPoint(442, 70, "getTimeBetweenEvictionRunsMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(457, 71, "setTimeBetweenEvictionRunsMillis", "(J)V");
        lightClassmapListener2.putLineTouchPoint(458, 72, "setTimeBetweenEvictionRunsMillis", "(J)V");
        lightClassmapListener2.putLineTouchPoint(459, 73, "setTimeBetweenEvictionRunsMillis", "(J)V");
        lightClassmapListener2.putLineTouchPoint(477, 74, "getNumTestsPerEvictionRun", "()I");
        lightClassmapListener2.putLineTouchPoint(497, 75, "setNumTestsPerEvictionRun", "(I)V");
        lightClassmapListener2.putLineTouchPoint(498, 76, "setNumTestsPerEvictionRun", "(I)V");
        lightClassmapListener2.putLineTouchPoint(513, 77, "getMinEvictableIdleTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(531, 78, "setMinEvictableIdleTimeMillis", "(J)V");
        lightClassmapListener2.putLineTouchPoint(532, 79, "setMinEvictableIdleTimeMillis", "(J)V");
        lightClassmapListener2.putLineTouchPoint(550, 80, "getSoftMinEvictableIdleTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(572, 81, "setSoftMinEvictableIdleTimeMillis", "(J)V");
        lightClassmapListener2.putLineTouchPoint(573, 82, "setSoftMinEvictableIdleTimeMillis", "(J)V");
        lightClassmapListener2.putLineTouchPoint(584, 83, "getEvictionPolicyClassName", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(603, 84, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(603, 85, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(604, 86, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(605, 87, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(606, 88, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(607, 89, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(608, 90, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(609, 91, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(609, 93, 92);
        lightClassmapListener2.putLineTouchPoint(611, 94, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(612, 95, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(614, 96, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(615, 97, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(618, 98, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(619, 99, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(622, 100, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(623, 101, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(626, 102, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(627, 103, "setEvictionPolicyClassName", "(Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(641, 104, "isClosed", "()Z");
        lightClassmapListener2.putLineTouchPoint(663, 105, "getEvictionPolicy", "()Lorg/apache/commons/pool2/impl/EvictionPolicy;");
        lightClassmapListener2.putLineTouchPoint(671, 106, "assertOpen", "()V");
        lightClassmapListener2.putJumpTouchPoint(671, 108, 107);
        lightClassmapListener2.putLineTouchPoint(672, 109, "assertOpen", "()V");
        lightClassmapListener2.putLineTouchPoint(674, 110, "assertOpen", "()V");
        lightClassmapListener2.putLineTouchPoint(687, 111, "startEvictor", "(J)V");
        lightClassmapListener2.putLineTouchPoint(688, 112, "startEvictor", "(J)V");
        lightClassmapListener2.putJumpTouchPoint(688, 114, 113);
        lightClassmapListener2.putLineTouchPoint(689, 115, "startEvictor", "(J)V");
        lightClassmapListener2.putLineTouchPoint(690, 116, "startEvictor", "(J)V");
        lightClassmapListener2.putLineTouchPoint(691, 117, "startEvictor", "(J)V");
        lightClassmapListener2.putLineTouchPoint(693, 118, "startEvictor", "(J)V");
        lightClassmapListener2.putJumpTouchPoint(693, 120, 119);
        lightClassmapListener2.putLineTouchPoint(694, 121, "startEvictor", "(J)V");
        lightClassmapListener2.putLineTouchPoint(695, 122, "startEvictor", "(J)V");
        lightClassmapListener2.putLineTouchPoint(697, 123, "startEvictor", "(J)V");
        lightClassmapListener2.putLineTouchPoint(698, 124, "startEvictor", "(J)V");
        lightClassmapListener2.putLineTouchPoint(717, 125, "getJmxName", "()Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(729, 126, "getCreationStackTrace", "()Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(738, 127, "getBorrowedCount", "()J");
        lightClassmapListener2.putLineTouchPoint(748, 128, "getReturnedCount", "()J");
        lightClassmapListener2.putLineTouchPoint(757, 129, "getCreatedCount", "()J");
        lightClassmapListener2.putLineTouchPoint(766, 130, "getDestroyedCount", "()J");
        lightClassmapListener2.putLineTouchPoint(775, 131, "getDestroyedByEvictorCount", "()J");
        lightClassmapListener2.putLineTouchPoint(785, 132, "getDestroyedByBorrowValidationCount", "()J");
        lightClassmapListener2.putLineTouchPoint(795, 133, "getMeanActiveTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(805, 134, "getMeanIdleTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(815, 135, "getMeanBorrowWaitTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(823, 136, "getMaxBorrowWaitTimeMillis", "()J");
        lightClassmapListener2.putLineTouchPoint(839, 137, "getSwallowedExceptionListener", "()Lorg/apache/commons/pool2/SwallowedExceptionListener;");
        lightClassmapListener2.putLineTouchPoint(851, 138, "setSwallowedExceptionListener", "(Lorg/apache/commons/pool2/SwallowedExceptionListener;)V");
        lightClassmapListener2.putLineTouchPoint(852, 139, "setSwallowedExceptionListener", "(Lorg/apache/commons/pool2/SwallowedExceptionListener;)V");
        lightClassmapListener2.putLineTouchPoint(861, 140, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putLineTouchPoint(863, 141, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putJumpTouchPoint(863, 143, 142);
        lightClassmapListener2.putLineTouchPoint(864, 144, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putLineTouchPoint(868, 145, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putLineTouchPoint(869, 146, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putLineTouchPoint(870, 147, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putLineTouchPoint(871, 148, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putLineTouchPoint(872, 149, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putLineTouchPoint(873, 150, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putLineTouchPoint(875, 151, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putLineTouchPoint(876, 152, "swallowException", "(Ljava/lang/Exception;)V");
        lightClassmapListener2.putLineTouchPoint(884, 153, "updateStatsBorrow", "(Lorg/apache/commons/pool2/PooledObject;J)V");
        lightClassmapListener2.putLineTouchPoint(885, 154, "updateStatsBorrow", "(Lorg/apache/commons/pool2/PooledObject;J)V");
        lightClassmapListener2.putLineTouchPoint(886, 155, "updateStatsBorrow", "(Lorg/apache/commons/pool2/PooledObject;J)V");
        lightClassmapListener2.putLineTouchPoint(891, 156, "updateStatsBorrow", "(Lorg/apache/commons/pool2/PooledObject;J)V");
        lightClassmapListener2.putLineTouchPoint(892, 157, "updateStatsBorrow", "(Lorg/apache/commons/pool2/PooledObject;J)V");
        lightClassmapListener2.putJumpTouchPoint(892, 159, 158);
        lightClassmapListener2.putLineTouchPoint(893, 160, "updateStatsBorrow", "(Lorg/apache/commons/pool2/PooledObject;J)V");
        lightClassmapListener2.putLineTouchPoint(895, 161, "updateStatsBorrow", "(Lorg/apache/commons/pool2/PooledObject;J)V");
        lightClassmapListener2.putJumpTouchPoint(895, 163, 162);
        lightClassmapListener2.putLineTouchPoint(896, 164, "updateStatsBorrow", "(Lorg/apache/commons/pool2/PooledObject;J)V");
        lightClassmapListener2.putLineTouchPoint(904, 165, "updateStatsReturn", "(J)V");
        lightClassmapListener2.putLineTouchPoint(905, 166, "updateStatsReturn", "(J)V");
        lightClassmapListener2.putLineTouchPoint(906, 167, "updateStatsReturn", "(J)V");
        lightClassmapListener2.putLineTouchPoint(912, 168, "jmxUnregister", "()V");
        lightClassmapListener2.putJumpTouchPoint(912, 170, 169);
        lightClassmapListener2.putLineTouchPoint(914, 171, "jmxUnregister", "()V");
        lightClassmapListener2.putLineTouchPoint(916, 172, "jmxUnregister", "()V");
        lightClassmapListener2.putLineTouchPoint(917, 173, "jmxUnregister", "()V");
        lightClassmapListener2.putLineTouchPoint(918, 174, "jmxUnregister", "()V");
        lightClassmapListener2.putLineTouchPoint(919, 175, "jmxUnregister", "()V");
        lightClassmapListener2.putLineTouchPoint(920, 176, "jmxUnregister", "()V");
        lightClassmapListener2.putLineTouchPoint(920, 177, "jmxUnregister", "()V");
        lightClassmapListener2.putLineTouchPoint(922, 178, "jmxUnregister", "()V");
        lightClassmapListener2.putLineTouchPoint(939, 179, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(940, 180, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(941, 181, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(942, 182, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(943, 183, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(944, 184, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putJumpTouchPoint(944, 186, 185);
        lightClassmapListener2.putLineTouchPoint(945, 187, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(947, 188, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putJumpTouchPoint(947, 190, 189);
        lightClassmapListener2.putLineTouchPoint(952, 191, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putJumpTouchPoint(952, 193, 192);
        lightClassmapListener2.putLineTouchPoint(953, 194, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(955, 195, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(957, 196, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(958, 197, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(959, 198, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(960, 199, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(961, 200, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putJumpTouchPoint(961, 202, 201);
        lightClassmapListener2.putLineTouchPoint(962, 203, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putJumpTouchPoint(962, 205, 204);
        lightClassmapListener2.putLineTouchPoint(964, 206, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(967, 207, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(969, 208, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(971, 209, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(973, 210, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(974, 211, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(976, 212, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(977, 213, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(979, 214, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(980, 215, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(980, 216, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(980, 217, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(980, 218, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(980, 219, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(982, 220, "jmxRegister", "(Lorg/apache/commons/pool2/impl/BaseObjectPoolConfig;Ljava/lang/String;Ljava/lang/String;)Ljavax/management/ObjectName;");
        lightClassmapListener2.putLineTouchPoint(994, 221, "getStackTrace", "(Ljava/lang/Exception;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(995, 222, "getStackTrace", "(Ljava/lang/Exception;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(996, 223, "getStackTrace", "(Ljava/lang/Exception;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(997, 224, "getStackTrace", "(Ljava/lang/Exception;)Ljava/lang/String;");
    }

    public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/BaseGenericObjectPool");
        lightClassmapListener2.setSource("BaseGenericObjectPool.java");
        BaseGenericObjectPool.__cobertura_classmap_0(lightClassmapListener2);
    }

    public static int[] __cobertura_get_and_reset_counters() {
        int[] nArray = __cobertura_counters;
        __cobertura_counters = new int[__cobertura_counters.length];
        return nArray;
    }

    static class IdentityWrapper<T> {
        public static final transient int[] __cobertura_counters;
        private final T instance;

        /*
         * WARNING - void declaration
         */
        public IdentityWrapper(T t) {
            void instance;
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            this.instance = instance;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
        }

        public int hashCode() {
            int n = 0;
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            return System.identityHashCode(this.instance);
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object object) {
            boolean bl;
            void other;
            int n = 0;
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            n = 7;
            if (((IdentityWrapper)other).instance == this.instance) {
                __cobertura_counters[6] = __cobertura_counters[6] + 1;
                n = 0;
                bl = true;
            } else {
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                bl = false;
            }
            return bl;
        }

        public T getObject() {
            int n = 0;
            __cobertura_counters[8] = __cobertura_counters[8] + 1;
            return this.instance;
        }

        static {
            IdentityWrapper.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[9];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/BaseGenericObjectPool$IdentityWrapper");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1182, 1, "<init>", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1183, 2, "<init>", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1184, 3, "<init>", "(Ljava/lang/Object;)V");
            lightClassmapListener2.putLineTouchPoint(1188, 4, "hashCode", "()I");
            lightClassmapListener2.putLineTouchPoint(1194, 5, "equals", "(Ljava/lang/Object;)Z");
            lightClassmapListener2.putJumpTouchPoint(1194, 7, 6);
            lightClassmapListener2.putLineTouchPoint(1201, 8, "getObject", "()Ljava/lang/Object;");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/BaseGenericObjectPool$IdentityWrapper");
            lightClassmapListener2.setSource("BaseGenericObjectPool.java");
            IdentityWrapper.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    class EvictionIterator
    implements Iterator<PooledObject<T>> {
        public static final transient int[] __cobertura_counters;
        private final Deque<PooledObject<T>> idleObjects;
        private final Iterator<PooledObject<T>> idleObjectIterator;
        final /* synthetic */ BaseGenericObjectPool this$0;

        /*
         * WARNING - void declaration
         */
        EvictionIterator(BaseGenericObjectPool baseGenericObjectPool, Deque<PooledObject<T>> deque) {
            void idleObjects;
            void this$0;
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            this.this$0 = this$0;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            this.idleObjects = idleObjects;
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            n = 6;
            if (this$0.getLifo()) {
                __cobertura_counters[5] = __cobertura_counters[5] + 1;
                n = 0;
                __cobertura_counters[7] = __cobertura_counters[7] + 1;
                this.idleObjectIterator = idleObjects.descendingIterator();
            } else {
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[8] = __cobertura_counters[8] + 1;
                this.idleObjectIterator = idleObjects.iterator();
            }
            __cobertura_counters[9] = __cobertura_counters[9] + 1;
        }

        public Deque<PooledObject<T>> getIdleObjects() {
            int n = 0;
            __cobertura_counters[10] = __cobertura_counters[10] + 1;
            return this.idleObjects;
        }

        @Override
        public boolean hasNext() {
            int n = 0;
            __cobertura_counters[11] = __cobertura_counters[11] + 1;
            return this.idleObjectIterator.hasNext();
        }

        @Override
        public PooledObject<T> next() {
            int n = 0;
            __cobertura_counters[12] = __cobertura_counters[12] + 1;
            return this.idleObjectIterator.next();
        }

        @Override
        public void remove() {
            int n = 0;
            __cobertura_counters[13] = __cobertura_counters[13] + 1;
            this.idleObjectIterator.remove();
            __cobertura_counters[14] = __cobertura_counters[14] + 1;
        }

        static {
            EvictionIterator.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[15];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/BaseGenericObjectPool$EvictionIterator");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1117, 1, "next", "()Ljava/lang/Object;");
            lightClassmapListener2.putLineTouchPoint(1126, 2, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;Ljava/util/Deque;)V");
            lightClassmapListener2.putLineTouchPoint(1127, 3, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;Ljava/util/Deque;)V");
            lightClassmapListener2.putLineTouchPoint(1129, 4, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;Ljava/util/Deque;)V");
            lightClassmapListener2.putJumpTouchPoint(1129, 6, 5);
            lightClassmapListener2.putLineTouchPoint(1130, 7, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;Ljava/util/Deque;)V");
            lightClassmapListener2.putLineTouchPoint(1132, 8, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;Ljava/util/Deque;)V");
            lightClassmapListener2.putLineTouchPoint(1134, 9, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;Ljava/util/Deque;)V");
            lightClassmapListener2.putLineTouchPoint(1141, 10, "getIdleObjects", "()Ljava/util/Deque;");
            lightClassmapListener2.putLineTouchPoint(1147, 11, "hasNext", "()Z");
            lightClassmapListener2.putLineTouchPoint(1153, 12, "next", "()Lorg/apache/commons/pool2/PooledObject;");
            lightClassmapListener2.putLineTouchPoint(1159, 13, "remove", "()V");
            lightClassmapListener2.putLineTouchPoint(1160, 14, "remove", "()V");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/BaseGenericObjectPool$EvictionIterator");
            lightClassmapListener2.setSource("BaseGenericObjectPool.java");
            EvictionIterator.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private class StatsStore {
        public static final transient int[] __cobertura_counters;
        private final AtomicLong[] values;
        private final int size;
        private int index;
        final /* synthetic */ BaseGenericObjectPool this$0;

        /*
         * WARNING - void declaration
         */
        public StatsStore(BaseGenericObjectPool baseGenericObjectPool, int n) {
            void size;
            int n2 = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.this$0 = baseGenericObjectPool;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            this.size = size;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            this.values = new AtomicLong[size];
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            int i = 0;
            while (true) {
                n2 = 6;
                if (i >= size) break;
                __cobertura_counters[5] = __cobertura_counters[5] + 1;
                n2 = 0;
                __cobertura_counters[8] = __cobertura_counters[8] + 1;
                this.values[i] = new AtomicLong(-1L);
                __cobertura_counters[7] = __cobertura_counters[7] + 1;
                ++i;
            }
            int n3 = n2;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n2 = 0;
            __cobertura_counters[9] = __cobertura_counters[9] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public synchronized void add(long l) {
            void value;
            int n = 0;
            __cobertura_counters[10] = __cobertura_counters[10] + 1;
            this.values[this.index].set((long)value);
            __cobertura_counters[11] = __cobertura_counters[11] + 1;
            ++this.index;
            __cobertura_counters[12] = __cobertura_counters[12] + 1;
            n = 14;
            if (this.index == this.size) {
                __cobertura_counters[13] = __cobertura_counters[13] + 1;
                n = 0;
                __cobertura_counters[15] = __cobertura_counters[15] + 1;
                this.index = 0;
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[16] = __cobertura_counters[16] + 1;
        }

        public long getMean() {
            int n = 0;
            __cobertura_counters[17] = __cobertura_counters[17] + 1;
            double result = 0.0;
            __cobertura_counters[18] = __cobertura_counters[18] + 1;
            int counter = 0;
            __cobertura_counters[19] = __cobertura_counters[19] + 1;
            int i = 0;
            while (true) {
                n = 21;
                if (i >= this.size) break;
                __cobertura_counters[20] = __cobertura_counters[20] + 1;
                n = 0;
                __cobertura_counters[23] = __cobertura_counters[23] + 1;
                long value = this.values[i].get();
                __cobertura_counters[24] = __cobertura_counters[24] + 1;
                n = 26;
                if (value != -1L) {
                    __cobertura_counters[25] = __cobertura_counters[25] + 1;
                    n = 0;
                    __cobertura_counters[27] = __cobertura_counters[27] + 1;
                    __cobertura_counters[28] = __cobertura_counters[28] + 1;
                    result = result * ((double)(++counter - 1) / (double)counter) + (double)value / (double)counter;
                }
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[22] = __cobertura_counters[22] + 1;
                ++i;
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[29] = __cobertura_counters[29] + 1;
            return (long)result;
        }

        static {
            StatsStore.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[30];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/BaseGenericObjectPool$StatsStore");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1072, 1, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(1073, 2, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(1074, 3, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(1075, 4, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;I)V");
            lightClassmapListener2.putJumpTouchPoint(1075, 6, 5);
            lightClassmapListener2.putLineTouchPoint(1075, 7, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(1076, 8, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(1078, 9, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;I)V");
            lightClassmapListener2.putLineTouchPoint(1087, 10, "add", "(J)V");
            lightClassmapListener2.putLineTouchPoint(1088, 11, "add", "(J)V");
            lightClassmapListener2.putLineTouchPoint(1089, 12, "add", "(J)V");
            lightClassmapListener2.putJumpTouchPoint(1089, 14, 13);
            lightClassmapListener2.putLineTouchPoint(1090, 15, "add", "(J)V");
            lightClassmapListener2.putLineTouchPoint(1092, 16, "add", "(J)V");
            lightClassmapListener2.putLineTouchPoint(1100, 17, "getMean", "()J");
            lightClassmapListener2.putLineTouchPoint(1101, 18, "getMean", "()J");
            lightClassmapListener2.putLineTouchPoint(1102, 19, "getMean", "()J");
            lightClassmapListener2.putJumpTouchPoint(1102, 21, 20);
            lightClassmapListener2.putLineTouchPoint(1102, 22, "getMean", "()J");
            lightClassmapListener2.putLineTouchPoint(1103, 23, "getMean", "()J");
            lightClassmapListener2.putLineTouchPoint(1104, 24, "getMean", "()J");
            lightClassmapListener2.putJumpTouchPoint(1104, 26, 25);
            lightClassmapListener2.putLineTouchPoint(1105, 27, "getMean", "()J");
            lightClassmapListener2.putLineTouchPoint(1106, 28, "getMean", "()J");
            lightClassmapListener2.putLineTouchPoint(1110, 29, "getMean", "()J");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/BaseGenericObjectPool$StatsStore");
            lightClassmapListener2.setSource("BaseGenericObjectPool.java");
            StatsStore.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    class Evictor
    extends TimerTask {
        public static final transient int[] __cobertura_counters;
        final /* synthetic */ BaseGenericObjectPool this$0;

        /*
         * WARNING - void declaration
         */
        Evictor(BaseGenericObjectPool baseGenericObjectPool) {
            void this$0;
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.this$0 = this$0;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block8: {
                var1_1 = 0;
                Evictor.__cobertura_counters[2] = Evictor.__cobertura_counters[2] + 1;
                savedClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Evictor.__cobertura_counters[3] = Evictor.__cobertura_counters[3] + 1;
                    var1_1 = 5;
                    if (BaseGenericObjectPool.access$000(this.this$0) == null) ** GOTO lbl36
                    Evictor.__cobertura_counters[4] = Evictor.__cobertura_counters[4] + 1;
                    var1_1 = 0;
                    Evictor.__cobertura_counters[6] = Evictor.__cobertura_counters[6] + 1;
                    cl = (ClassLoader)BaseGenericObjectPool.access$000(this.this$0).get();
                    Evictor.__cobertura_counters[7] = Evictor.__cobertura_counters[7] + 1;
                    var1_1 = 9;
                    if (cl != null) break block8;
                    Evictor.__cobertura_counters[8] = Evictor.__cobertura_counters[8] + 1;
                    var1_1 = 0;
                    Evictor.__cobertura_counters[10] = Evictor.__cobertura_counters[10] + 1;
                    this.cancel();
                }
                catch (Throwable v0) {
                    Evictor.__cobertura_counters[24] = Evictor.__cobertura_counters[24] + 1;
                    var4_4 = v0;
                    Thread.currentThread().setContextClassLoader(savedClassLoader);
                    throw var4_4;
                }
                Evictor.__cobertura_counters[24] = Evictor.__cobertura_counters[24] + 1;
                Thread.currentThread().setContextClassLoader(savedClassLoader);
                Evictor.__cobertura_counters[11] = Evictor.__cobertura_counters[11] + 1;
                return;
            }
            v1 = var1_1;
            Evictor.__cobertura_counters[v1] = Evictor.__cobertura_counters[v1] + 1;
            var1_1 = 0;
            Evictor.__cobertura_counters[12] = Evictor.__cobertura_counters[12] + 1;
            Thread.currentThread().setContextClassLoader(cl);
lbl36:
            // 2 sources

            try {
                v2 = var1_1;
                Evictor.__cobertura_counters[v2] = Evictor.__cobertura_counters[v2] + 1;
                var1_1 = 0;
                Evictor.__cobertura_counters[13] = Evictor.__cobertura_counters[13] + 1;
                this.this$0.evict();
            }
            catch (Exception v3) {
                Evictor.__cobertura_counters[14] = Evictor.__cobertura_counters[14] + 1;
                e = v3;
                Evictor.__cobertura_counters[15] = Evictor.__cobertura_counters[15] + 1;
                this.this$0.swallowException(e);
                Evictor.__cobertura_counters[19] = Evictor.__cobertura_counters[19] + 1;
            }
            catch (OutOfMemoryError v4) {
                Evictor.__cobertura_counters[16] = Evictor.__cobertura_counters[16] + 1;
                oome = v4;
                Evictor.__cobertura_counters[17] = Evictor.__cobertura_counters[17] + 1;
                oome.printStackTrace(System.err);
            }
            Evictor.__cobertura_counters[18] = Evictor.__cobertura_counters[18] + 1;
            try {
                Evictor.__cobertura_counters[20] = Evictor.__cobertura_counters[20] + 1;
                this.this$0.ensureMinIdle();
            }
            catch (Exception v5) {
                Evictor.__cobertura_counters[21] = Evictor.__cobertura_counters[21] + 1;
                e = v5;
                Evictor.__cobertura_counters[22] = Evictor.__cobertura_counters[22] + 1;
                this.this$0.swallowException(e);
            }
            Evictor.__cobertura_counters[23] = Evictor.__cobertura_counters[23] + 1;
            Evictor.__cobertura_counters[24] = Evictor.__cobertura_counters[24] + 1;
            Thread.currentThread().setContextClassLoader(savedClassLoader);
            Evictor.__cobertura_counters[25] = Evictor.__cobertura_counters[25] + 1;
            Evictor.__cobertura_counters[26] = Evictor.__cobertura_counters[26] + 1;
        }

        static {
            Evictor.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[27];
                TouchCollector.registerClass((String)"org/apache/commons/pool2/impl/BaseGenericObjectPool$Evictor");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1007, 1, "<init>", "(Lorg/apache/commons/pool2/impl/BaseGenericObjectPool;)V");
            lightClassmapListener2.putLineTouchPoint(1019, 2, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1021, 3, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1021, 5, 4);
            lightClassmapListener2.putLineTouchPoint(1023, 6, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1024, 7, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1024, 9, 8);
            lightClassmapListener2.putLineTouchPoint(1028, 10, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1029, 11, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1031, 12, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1036, 13, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1037, 14, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1038, 15, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1039, 16, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1042, 17, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1043, 18, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1043, 19, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1046, 20, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1047, 21, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1048, 22, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1049, 23, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1052, 24, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1053, 25, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1054, 26, "run", "()V");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/apache/commons/pool2/impl/BaseGenericObjectPool$Evictor");
            lightClassmapListener2.setSource("BaseGenericObjectPool.java");
            Evictor.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }
}

