/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.random;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.NotANumberException;
import org.apache.commons.math4.exception.NotFiniteNumberException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.rng.UniformRandomProvider;

public class RandomUtils {
    private RandomUtils() {
    }

    public static DataGenerator createDataGenerator(UniformRandomProvider rng) {
        return new DataGenerator(rng);
    }

    public static DataGenerator createDataGenerator(Random rng) {
        return RandomUtils.createDataGenerator(RandomUtils.asUniformRandomProvider(rng));
    }

    public static UniformRandomProvider asUniformRandomProvider(final Random rng) {
        return new UniformRandomProvider(){

            public void nextBytes(byte[] bytes) {
                rng.nextBytes(bytes);
            }

            public void nextBytes(byte[] bytes, int start, int len) {
                byte[] reduced = new byte[len];
                rng.nextBytes(reduced);
                System.arraycopy(reduced, 0, bytes, start, len);
            }

            public int nextInt() {
                return rng.nextInt();
            }

            public int nextInt(int n) {
                if (n <= 0) {
                    throw new NotStrictlyPositiveException(n);
                }
                return rng.nextInt(n);
            }

            public long nextLong() {
                return rng.nextLong();
            }

            public long nextLong(long n) {
                if (n > 0L) {
                    long val;
                    long bits;
                    while ((bits = rng.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
                    }
                    return val;
                }
                throw new NotStrictlyPositiveException(n);
            }

            public boolean nextBoolean() {
                return rng.nextBoolean();
            }

            public float nextFloat() {
                return rng.nextFloat();
            }

            public double nextDouble() {
                return rng.nextDouble();
            }
        };
    }

    public static class DataGenerator {
        private final UniformRandomProvider rng;

        DataGenerator(UniformRandomProvider rng) {
            this.rng = rng;
        }

        public String nextHexString(int len, boolean useSha1) {
            if (len <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, len);
            }
            StringBuilder outBuffer = new StringBuilder();
            if (!useSha1) {
                byte[] randomBytes = new byte[len / 2 + 1];
                this.rng.nextBytes(randomBytes);
                for (int i = 0; i < randomBytes.length; ++i) {
                    Integer c = randomBytes[i];
                    String hex = Integer.toHexString(c + 128);
                    if (hex.length() == 1) {
                        hex = "0" + hex;
                    }
                    outBuffer.append(hex);
                }
            } else {
                MessageDigest alg = null;
                try {
                    alg = MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new MathInternalError(ex);
                }
                alg.reset();
                int numIter = len / 40 + 1;
                for (int iter = 1; iter < numIter + 1; ++iter) {
                    byte[] randomBytes = new byte[40];
                    this.rng.nextBytes(randomBytes);
                    alg.update(randomBytes);
                    byte[] hash = alg.digest();
                    for (int i = 0; i < hash.length; ++i) {
                        Integer c = hash[i];
                        String hex = Integer.toHexString(c + 128);
                        if (hex.length() == 1) {
                            hex = "0" + hex;
                        }
                        outBuffer.append(hex);
                    }
                }
            }
            return outBuffer.toString().substring(0, len);
        }

        public long nextLong(long lower, long upper) {
            if (lower >= upper) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
            }
            long max = upper - lower + 1L;
            if (max <= 0L) {
                long r;
                while ((r = this.rng.nextLong()) < lower || r > upper) {
                }
                return r;
            }
            if (max < Integer.MAX_VALUE) {
                return lower + (long)this.rng.nextInt((int)max);
            }
            return lower + this.rng.nextLong(max);
        }

        public double nextUniform(double lower, double upper) {
            return this.nextUniform(lower, upper, false);
        }

        public double nextUniform(double lower, double upper, boolean lowerInclusive) {
            if (lower >= upper) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
            }
            if (Double.isInfinite(lower)) {
                throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, lower, new Object[0]);
            }
            if (Double.isInfinite(upper)) {
                throw new NotFiniteNumberException((Localizable)LocalizedFormats.INFINITE_BOUND, upper, new Object[0]);
            }
            if (Double.isNaN(lower) || Double.isNaN(upper)) {
                throw new NotANumberException();
            }
            double u = this.rng.nextDouble();
            while (!lowerInclusive && u <= 0.0) {
                u = this.rng.nextDouble();
            }
            return u * upper + (1.0 - u) * lower;
        }
    }
}

