/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.optim;

import org.apache.commons.math4.exception.TooManyEvaluationsException;
import org.apache.commons.math4.exception.TooManyIterationsException;
import org.apache.commons.math4.optim.ConvergenceChecker;
import org.apache.commons.math4.optim.MaxEval;
import org.apache.commons.math4.optim.MaxIter;
import org.apache.commons.math4.optim.OptimizationData;
import org.apache.commons.math4.util.IntegerSequence;

public abstract class BaseOptimizer<PAIR> {
    private static final MaxEvalCallback MAX_EVAL_CALLBACK = new MaxEvalCallback();
    private static final MaxIterCallback MAX_ITER_CALLBACK = new MaxIterCallback();
    private final ConvergenceChecker<PAIR> checker;
    private int maxEvaluations;
    private int maxIterations;
    private IntegerSequence.Incrementor evaluations;
    private IntegerSequence.Incrementor iterations;

    protected BaseOptimizer(ConvergenceChecker<PAIR> checker) {
        this(checker, 0, Integer.MAX_VALUE);
    }

    protected BaseOptimizer(ConvergenceChecker<PAIR> checker, int maxEval, int maxIter) {
        this.checker = checker;
        this.maxEvaluations = maxEval;
        this.maxIterations = maxIter;
    }

    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    public int getMaxIterations() {
        return this.iterations.getMaximalCount();
    }

    public int getIterations() {
        return this.iterations.getCount();
    }

    public ConvergenceChecker<PAIR> getConvergenceChecker() {
        return this.checker;
    }

    public PAIR optimize(OptimizationData ... optData) throws TooManyEvaluationsException, TooManyIterationsException {
        this.parseOptimizationData(optData);
        this.resetCounters();
        return this.doOptimize();
    }

    public PAIR optimize() throws TooManyEvaluationsException, TooManyIterationsException {
        this.resetCounters();
        return this.doOptimize();
    }

    protected abstract PAIR doOptimize();

    protected void incrementEvaluationCount() throws TooManyEvaluationsException {
        this.evaluations.increment();
    }

    protected void incrementIterationCount() throws TooManyIterationsException {
        this.iterations.increment();
    }

    protected void parseOptimizationData(OptimizationData ... optData) {
        for (OptimizationData data : optData) {
            if (data instanceof MaxEval) {
                this.maxEvaluations = ((MaxEval)data).getMaxEval();
                continue;
            }
            if (!(data instanceof MaxIter)) continue;
            this.maxIterations = ((MaxIter)data).getMaxIter();
        }
    }

    private void resetCounters() {
        this.evaluations = IntegerSequence.Incrementor.create().withMaximalCount(this.maxEvaluations).withCallback(MAX_EVAL_CALLBACK);
        this.iterations = IntegerSequence.Incrementor.create().withMaximalCount(this.maxIterations).withCallback(MAX_ITER_CALLBACK);
    }

    private static class MaxIterCallback
    implements IntegerSequence.Incrementor.MaxCountExceededCallback {
        private MaxIterCallback() {
        }

        @Override
        public void trigger(int max) {
            throw new TooManyIterationsException(max);
        }
    }

    private static class MaxEvalCallback
    implements IntegerSequence.Incrementor.MaxCountExceededCallback {
        private MaxEvalCallback() {
        }

        @Override
        public void trigger(int max) {
            throw new TooManyEvaluationsException(max);
        }
    }
}

