/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import java.io.Serializable;
import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousInverseCumulativeProbabilityFunction;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformContinuousSampler;
import org.apache.commons.statistics.distribution.ContinuousDistribution;

public abstract class AbstractRealDistribution
implements ContinuousDistribution,
Serializable {
    public static final double SOLVER_DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private static final long serialVersionUID = 20160311L;

    public double probability(double x0, double x1) {
        if (x0 > x1) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)x0, x1, true);
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    public double inverseCumulativeProbability(final double p) throws OutOfRangeException {
        double dx;
        boolean chebyshevApplies;
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException(p, (Number)0, 1);
        }
        double lowerBound = this.getSupportLowerBound();
        if (p == 0.0) {
            return lowerBound;
        }
        double upperBound = this.getSupportUpperBound();
        if (p == 1.0) {
            return upperBound;
        }
        double mu = this.getMean();
        double sig = FastMath.sqrt(this.getVariance());
        boolean bl = chebyshevApplies = !Double.isInfinite(mu) && !Double.isNaN(mu) && !Double.isInfinite(sig) && !Double.isNaN(sig);
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            if (chebyshevApplies) {
                lowerBound = mu - sig * FastMath.sqrt((1.0 - p) / p);
            } else {
                lowerBound = -1.0;
                while (this.cumulativeProbability(lowerBound) >= p) {
                    lowerBound *= 2.0;
                }
            }
        }
        if (upperBound == Double.POSITIVE_INFINITY) {
            if (chebyshevApplies) {
                upperBound = mu + sig * FastMath.sqrt(p / (1.0 - p));
            } else {
                upperBound = 1.0;
                while (this.cumulativeProbability(upperBound) < p) {
                    upperBound *= 2.0;
                }
            }
        }
        UnivariateFunction toSolve = new UnivariateFunction(){

            @Override
            public double value(double x) {
                return AbstractRealDistribution.this.cumulativeProbability(x) - p;
            }
        };
        double x = UnivariateSolverUtils.solve(toSolve, lowerBound, upperBound, this.getSolverAbsoluteAccuracy());
        if (!this.isSupportConnected() && x - (dx = this.getSolverAbsoluteAccuracy()) >= this.getSupportLowerBound()) {
            double px = this.cumulativeProbability(x);
            if (this.cumulativeProbability(x - dx) == px) {
                upperBound = x;
                while (upperBound - lowerBound > dx) {
                    double midPoint = 0.5 * (lowerBound + upperBound);
                    if (this.cumulativeProbability(midPoint) < px) {
                        lowerBound = midPoint;
                        continue;
                    }
                    upperBound = midPoint;
                }
                return upperBound;
            }
        }
        return x;
    }

    protected double getSolverAbsoluteAccuracy() {
        return 1.0E-6;
    }

    public double probability(double x) {
        return 0.0;
    }

    public double logDensity(double x) {
        return FastMath.log(this.density(x));
    }

    public static double[] sample(int n, ContinuousDistribution.Sampler sampler) {
        double[] samples = new double[n];
        for (int i = 0; i < n; ++i) {
            samples[i] = sampler.sample();
        }
        return samples;
    }

    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider rng) {
        return new ContinuousDistribution.Sampler(){
            private final ContinuousSampler sampler;
            {
                this.sampler = new InverseTransformContinuousSampler(rng, AbstractRealDistribution.this.createICPF());
            }

            public double sample() {
                return this.sampler.sample();
            }
        };
    }

    private ContinuousInverseCumulativeProbabilityFunction createICPF() {
        return new ContinuousInverseCumulativeProbabilityFunction(){

            public double inverseCumulativeProbability(double p) {
                return AbstractRealDistribution.this.inverseCumulativeProbability(p);
            }
        };
    }
}

