/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration;

import org.apache.commons.math4.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.util.FastMath;

public class TrapezoidIntegrator
extends BaseAbstractUnivariateIntegrator {
    private static final int TRAPEZOID_MAX_ITERATIONS_COUNT = 63;
    private double s;

    public TrapezoidIntegrator(double relativeAccuracy, double absoluteAccuracy, int minimalIterationCount, int maximalIterationCount) {
        super(relativeAccuracy, absoluteAccuracy, minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 63) {
            throw new NumberIsTooLargeException(maximalIterationCount, (Number)63, false);
        }
    }

    public TrapezoidIntegrator(int minimalIterationCount, int maximalIterationCount) {
        super(minimalIterationCount, maximalIterationCount);
        if (maximalIterationCount > 63) {
            throw new NumberIsTooLargeException(maximalIterationCount, (Number)63, false);
        }
    }

    public TrapezoidIntegrator() {
        super(3, 63);
    }

    double stage(BaseAbstractUnivariateIntegrator baseIntegrator, int n) {
        if (n == 0) {
            double max = baseIntegrator.getMax();
            double min = baseIntegrator.getMin();
            this.s = 0.5 * (max - min) * (baseIntegrator.computeObjectiveValue(min) + baseIntegrator.computeObjectiveValue(max));
            return this.s;
        }
        long np = 1L << n - 1;
        double sum = 0.0;
        double max = baseIntegrator.getMax();
        double min = baseIntegrator.getMin();
        double spacing = (max - min) / (double)np;
        double x = min + 0.5 * spacing;
        for (long i = 0L; i < np; ++i) {
            sum += baseIntegrator.computeObjectiveValue(x);
            x += spacing;
        }
        this.s = 0.5 * (this.s + sum * spacing);
        return this.s;
    }

    @Override
    protected double doIntegrate() {
        double oldt = this.stage(this, 0);
        this.iterations.increment();
        while (true) {
            double rLimit;
            double delta;
            int i = this.iterations.getCount();
            double t = this.stage(this, i);
            if (i >= this.getMinimalIterationCount() && ((delta = FastMath.abs(t - oldt)) <= (rLimit = this.getRelativeAccuracy() * (FastMath.abs(oldt) + FastMath.abs(t)) * 0.5) || delta <= this.getAbsoluteAccuracy())) {
                return t;
            }
            oldt = t;
            this.iterations.increment();
        }
    }
}

