/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.optim.nonlinear.scalar;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.analysis.MultivariateFunction;
import org.apache.commons.math4.legacy.analysis.UnivariateFunction;
import org.apache.commons.math4.legacy.analysis.function.Logit;
import org.apache.commons.math4.legacy.analysis.function.Sigmoid;
import org.apache.commons.math4.legacy.exception.DimensionMismatchException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.NumberIsTooSmallException;

public class MultivariateFunctionMappingAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final Mapper[] mappers;

    public MultivariateFunctionMappingAdapter(MultivariateFunction bounded, double[] lower, double[] upper) {
        int i;
        NullArgumentException.check((Object)lower);
        NullArgumentException.check((Object)upper);
        if (lower.length != upper.length) {
            throw new DimensionMismatchException(lower.length, upper.length);
        }
        for (i = 0; i < lower.length; ++i) {
            if (upper[i] >= lower[i]) continue;
            throw new NumberIsTooSmallException((Number)upper[i], (Number)lower[i], true);
        }
        this.bounded = bounded;
        this.mappers = new Mapper[lower.length];
        for (i = 0; i < this.mappers.length; ++i) {
            if (Double.isInfinite(lower[i])) {
                if (Double.isInfinite(upper[i])) {
                    this.mappers[i] = new NoBoundsMapper();
                    continue;
                }
                this.mappers[i] = new UpperBoundMapper(upper[i]);
                continue;
            }
            this.mappers[i] = Double.isInfinite(upper[i]) ? new LowerBoundMapper(lower[i]) : new LowerUpperBoundMapper(lower[i], upper[i]);
        }
    }

    public double[] unboundedToBounded(double[] point) {
        double[] mapped = new double[this.mappers.length];
        for (int i = 0; i < this.mappers.length; ++i) {
            mapped[i] = this.mappers[i].unboundedToBounded(point[i]);
        }
        return mapped;
    }

    public double[] boundedToUnbounded(double[] point) {
        double[] mapped = new double[this.mappers.length];
        for (int i = 0; i < this.mappers.length; ++i) {
            mapped[i] = this.mappers[i].boundedToUnbounded(point[i]);
        }
        return mapped;
    }

    @Override
    public double value(double[] point) {
        return this.bounded.value(this.unboundedToBounded(point));
    }

    private static class LowerUpperBoundMapper
    implements Mapper {
        private final UnivariateFunction boundingFunction;
        private final UnivariateFunction unboundingFunction;

        LowerUpperBoundMapper(double lower, double upper) {
            this.boundingFunction = new Sigmoid(lower, upper);
            this.unboundingFunction = new Logit(lower, upper);
        }

        @Override
        public double unboundedToBounded(double y) {
            return this.boundingFunction.value(y);
        }

        @Override
        public double boundedToUnbounded(double x) {
            return this.unboundingFunction.value(x);
        }
    }

    private static class UpperBoundMapper
    implements Mapper {
        private final double upper;

        UpperBoundMapper(double upper) {
            this.upper = upper;
        }

        @Override
        public double unboundedToBounded(double y) {
            return this.upper - JdkMath.exp((double)(-y));
        }

        @Override
        public double boundedToUnbounded(double x) {
            return -JdkMath.log((double)(this.upper - x));
        }
    }

    private static class LowerBoundMapper
    implements Mapper {
        private final double lower;

        LowerBoundMapper(double lower) {
            this.lower = lower;
        }

        @Override
        public double unboundedToBounded(double y) {
            return this.lower + JdkMath.exp((double)y);
        }

        @Override
        public double boundedToUnbounded(double x) {
            return JdkMath.log((double)(x - this.lower));
        }
    }

    private static class NoBoundsMapper
    implements Mapper {
        private NoBoundsMapper() {
        }

        @Override
        public double unboundedToBounded(double y) {
            return y;
        }

        @Override
        public double boundedToUnbounded(double x) {
            return x;
        }
    }

    private static interface Mapper {
        public double unboundedToBounded(double var1);

        public double boundedToUnbounded(double var1);
    }
}

